/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.search.api.util;

import java.util.List;
import java.util.stream.Collectors;
import net.croz.nrich.search.api.model.sort.SortDirection;
import net.croz.nrich.search.api.model.sort.SortProperty;
import net.croz.nrich.search.api.request.SortablePageableRequest;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public final class PageableUtil {
    private PageableUtil() {
    }

    public static Pageable convertToPageable(SortablePageableRequest request, SortProperty uniqueSortProperty) {
        return PageableUtil.convertToPageable(request.getPageNumber(), request.getPageSize(), uniqueSortProperty, request.getSortPropertyList());
    }

    public static Pageable convertToPageable(SortablePageableRequest request) {
        return PageableUtil.convertToPageable(request.getPageNumber(), request.getPageSize(), request.getSortPropertyList());
    }

    public static Pageable convertToPageable(Integer pageNumber, Integer pageSize) {
        return PageableUtil.convertToPageable(pageNumber, pageSize, null, null);
    }

    public static Pageable convertToPageable(Integer pageNumber, Integer pageSize, SortProperty uniqueSortProperty) {
        return PageableUtil.convertToPageable(pageNumber, pageSize, uniqueSortProperty, null);
    }

    public static Pageable convertToPageable(Integer pageNumber, Integer pageSize, List<SortProperty> sortPropertyList) {
        return PageableUtil.convertToPageable(pageNumber, pageSize, null, sortPropertyList);
    }

    public static Pageable convertToPageable(Integer pageNumber, Integer pageSize, SortProperty uniqueSortProperty, List<SortProperty> sortPropertyList) {
        Sort sort;
        Sort.Order uniqueSortOrder = null;
        if (uniqueSortProperty != null) {
            uniqueSortOrder = PageableUtil.convertToSortOrder(uniqueSortProperty);
        }
        if (CollectionUtils.isEmpty(sortPropertyList)) {
            sort = uniqueSortOrder == null ? Sort.unsorted() : Sort.by((Sort.Order[])new Sort.Order[]{uniqueSortOrder});
        } else {
            List orderList = sortPropertyList.stream().map(PageableUtil::convertToSortOrder).collect(Collectors.toList());
            if (uniqueSortOrder != null && sortPropertyList.stream().map(SortProperty::getProperty).noneMatch(value -> value.equals(uniqueSortProperty.getProperty()))) {
                orderList.add(uniqueSortOrder);
            }
            sort = Sort.by(orderList);
        }
        return PageRequest.of((int)pageNumber, (int)pageSize, (Sort)sort);
    }

    private static Sort.Order convertToSortOrder(SortProperty sortProperty) {
        return sortProperty.getDirection() == SortDirection.ASC ? Sort.Order.asc((String)sortProperty.getProperty()) : Sort.Order.desc((String)sortProperty.getProperty());
    }
}

