/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.validation.constraint.validator;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.web.multipart.MultipartFile;

abstract class BaseValidFileValidator {
    private static final String PATH_SEPARATOR_REGEX = "\\.";
    private static final char UNIX_PATH_SEPARATOR = '/';
    private static final char WINDOWS_PATH_SEPARATOR = '\\';
    protected String[] allowedContentTypeList;
    protected String[] allowedExtensionList;
    protected String allowedFileNameRegex;

    BaseValidFileValidator() {
    }

    protected boolean isValid(Object value) {
        String[] fileNameList;
        String extension;
        String fileContentType;
        String fileName;
        if (value == null) {
            return true;
        }
        if (value instanceof MultipartFile) {
            fileName = this.extractFileName(((MultipartFile)value).getOriginalFilename());
            fileContentType = ((MultipartFile)value).getContentType();
        } else if (value instanceof FilePart) {
            fileName = this.extractFileName(((FilePart)value).filename());
            fileContentType = Optional.ofNullable(((FilePart)value).headers().getContentType()).map(Objects::toString).orElse(null);
        } else {
            throw new IllegalArgumentException(String.format("Unable to validate file, unrecognized type: %s", value.getClass()));
        }
        boolean valid = true;
        if (fileContentType != null && this.allowedContentTypeList.length > 0) {
            valid = Arrays.asList(this.allowedContentTypeList).contains(fileContentType);
        }
        if (!this.allowedFileNameRegex.isEmpty()) {
            valid &= fileName.matches(this.allowedFileNameRegex);
        }
        if (this.allowedExtensionList.length > 0 && (extension = (fileNameList = fileName.split(PATH_SEPARATOR_REGEX)).length > 1 ? fileNameList[fileNameList.length - 1] : null) != null) {
            valid &= Arrays.stream(this.allowedExtensionList).anyMatch(extension::equalsIgnoreCase);
        }
        return valid;
    }

    private String extractFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        int pos = fileName.lastIndexOf(47);
        if (pos == -1) {
            pos = fileName.lastIndexOf(92);
        }
        if (pos != -1) {
            return fileName.substring(pos + 1);
        }
        return fileName;
    }
}

