/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.validation.constraint.validator;

import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.croz.nrich.validation.api.constraint.ValidFileResolvable;
import net.croz.nrich.validation.constraint.validator.BaseValidFileValidator;
import org.springframework.core.env.Environment;

public class ValidFileResolvableValidator
extends BaseValidFileValidator
implements ConstraintValidator<ValidFileResolvable, Object> {
    private final Environment environment;

    public ValidFileResolvableValidator(Environment environment) {
        this.environment = environment;
    }

    public void initialize(ValidFileResolvable constraintAnnotation) {
        this.allowedContentTypeList = this.resolvePropertyValue(constraintAnnotation.allowedContentTypeListPropertyName(), String[].class, new String[0]);
        this.allowedExtensionList = this.resolvePropertyValue(constraintAnnotation.allowedExtensionListPropertyName(), String[].class, new String[0]);
        this.allowedFileNameRegex = this.resolvePropertyValue(constraintAnnotation.allowedFileNameRegexPropertyName(), String.class, "");
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        return this.isValid(value);
    }

    private <T> T resolvePropertyValue(String propertyName, Class<T> propertyType, T defaultPropertyValue) {
        if (!propertyName.isEmpty()) {
            return (T)Optional.ofNullable(this.environment.getProperty(propertyName, propertyType)).orElse(defaultPropertyValue);
        }
        return defaultPropertyValue;
    }
}

