/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.validation.constraint.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class ValidationReflectionUtil {
    private static final String[] METHOD_PATTERN_LIST = new String[]{"get%s", "is%s"};

    private ValidationReflectionUtil() {
    }

    public static Method findGetterMethod(Class<?> type, String fieldName) {
        String capitalizedFieldName = StringUtils.capitalize((String)fieldName);
        return Arrays.stream(METHOD_PATTERN_LIST).map(value -> String.format(value, capitalizedFieldName)).map(methodName -> ReflectionUtils.findMethod((Class)type, (String)methodName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod((Method)method, (Object)target);
    }
}

