/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.validation.constraint.validator;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import lombok.Generated;
import net.croz.nrich.validation.constraint.util.ValidationReflectionUtil;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

abstract class BaseNullableCheckValidator {
    private final AutowireCapableBeanFactory beanFactory;

    protected abstract boolean isPropertyValueValid(Object var1);

    protected boolean isValid(Object value, Class<? extends Predicate<?>> conditionClass, String propertyName) {
        if (value == null) {
            return true;
        }
        Predicate condition = (Predicate)this.beanFactory.autowire(conditionClass, 3, false);
        boolean conditionEvaluationResult = condition.test(value);
        if (!conditionEvaluationResult) {
            return true;
        }
        Object propertyValue = this.resolvePropertyValue(value, propertyName);
        return this.isPropertyValueValid(propertyValue);
    }

    private Object resolvePropertyValue(Object parent, String propertyName) {
        Method propertyGetterMethod = ValidationReflectionUtil.findGetterMethod(parent.getClass(), propertyName);
        if (propertyGetterMethod == null) {
            throw new IllegalArgumentException(String.format("No getter method found for property %s when invoking %s validator", propertyName, this.getClass().getSimpleName()));
        }
        return ValidationReflectionUtil.invokeMethod(propertyGetterMethod, parent);
    }

    @ConstructorProperties(value={"beanFactory"})
    @Generated
    public BaseNullableCheckValidator(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

