/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.validation.constraint.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.nio.charset.Charset;
import net.croz.nrich.validation.api.constraint.MaxSizeInBytes;

public class MaxSizeInBytesValidator
implements ConstraintValidator<MaxSizeInBytes, String> {
    private int maxSizeInBytes;
    private Charset charset;

    public void initialize(MaxSizeInBytes constraintAnnotation) {
        this.maxSizeInBytes = constraintAnnotation.value();
        this.charset = Charset.forName(constraintAnnotation.encoding());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return value.getBytes(this.charset).length <= this.maxSizeInBytes;
    }
}

