/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.validation.constraint.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import net.croz.nrich.validation.api.constraint.ValidRange;
import net.croz.nrich.validation.constraint.util.ValidationReflectionUtil;

public class ValidRangeValidator
implements ConstraintValidator<ValidRange, Object> {
    private String fromPropertyName;
    private String toPropertyName;
    private boolean inclusive;

    public void initialize(ValidRange constraintAnnotation) {
        this.fromPropertyName = constraintAnnotation.fromPropertyName();
        this.toPropertyName = constraintAnnotation.toPropertyName();
        this.inclusive = constraintAnnotation.inclusive();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        Class<?> type = value.getClass();
        Method fromFieldGetter = ValidationReflectionUtil.findGetterMethod(type, this.fromPropertyName);
        Method toFieldGetter = ValidationReflectionUtil.findGetterMethod(type, this.toPropertyName);
        Object fromFieldValue = ValidationReflectionUtil.invokeMethod(fromFieldGetter, value);
        Object toFieldValue = ValidationReflectionUtil.invokeMethod(toFieldGetter, value);
        if (fromFieldValue == null || toFieldValue == null) {
            return true;
        }
        if (!(fromFieldValue instanceof Comparable && toFieldValue instanceof Comparable && fromFieldValue.getClass().equals(toFieldValue.getClass()))) {
            throw new IllegalArgumentException("Both to and from fields have to be instances of comparable and of same type");
        }
        int compareResult = ((Comparable)fromFieldValue).compareTo(toFieldValue);
        return compareResult < 0 || this.inclusive && compareResult == 0;
    }
}

