/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.validation.constraint.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.croz.nrich.validation.api.constraint.ValidSearchProperties;
import net.croz.nrich.validation.constraint.util.ValidationReflectionUtil;

public class ValidSearchPropertiesValidator
implements ConstraintValidator<ValidSearchProperties, Object> {
    private Map<String, String[]> propertyGroupMap;

    public void initialize(ValidSearchProperties constraintAnnotation) {
        ValidSearchProperties.PropertyGroup[] propertyGroupList = constraintAnnotation.propertyGroup();
        this.propertyGroupMap = IntStream.range(0, propertyGroupList.length).boxed().collect(Collectors.toConcurrentMap(Object::toString, value -> propertyGroupList[value].value()));
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        Class<?> type = value.getClass();
        return this.propertyGroupMap.entrySet().stream().anyMatch(fieldGroup -> {
            List methodList = Arrays.stream((String[])fieldGroup.getValue()).map(fieldName -> ValidationReflectionUtil.findGetterMethod(type, fieldName)).collect(Collectors.toList());
            return methodList.stream().allMatch(method -> ValidationReflectionUtil.invokeMethod(method, value) != null);
        });
    }
}

