/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.csdn.common.Booleans;
import net.csdn.common.Classes;
import net.csdn.common.Strings;
import net.csdn.common.exception.SettingsException;
import net.csdn.common.io.Streams;
import net.csdn.common.property.PropertyPlaceholder;
import net.csdn.common.settings.NoClassSettingsException;
import net.csdn.common.settings.Settings;
import net.csdn.common.unit.ByteSizeUnit;
import net.csdn.common.unit.ByteSizeValue;
import net.csdn.common.unit.SizeValue;
import net.csdn.common.unit.TimeValue;
import org.yaml.snakeyaml.Yaml;
import tech.mlsql.common.utils.collect.ImmutableMap;
import tech.mlsql.common.utils.collect.Lists;
import tech.mlsql.common.utils.collect.Maps;

public class ImmutableSettings
implements Settings {
    private ImmutableMap<String, String> settings;
    private transient ClassLoader classLoader;

    private ImmutableSettings(Map<String, String> settings, ClassLoader classLoader) {
        this.settings = ImmutableMap.copyOf(settings);
        this.classLoader = classLoader == null ? ImmutableSettings.buildClassLoader() : classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ImmutableMap<String, String> getAsMap() {
        return this.settings;
    }

    @Override
    public Settings getByPrefix(String prefix) {
        Builder builder = new Builder();
        for (Map.Entry entry : this.getAsMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix) || ((String)entry.getKey()).length() < prefix.length()) continue;
            builder.put(((String)entry.getKey()).substring(prefix.length()), (String)entry.getValue());
        }
        builder.classLoader(this.classLoader);
        return builder.build();
    }

    @Override
    public String get(String setting) {
        String retVal = (String)this.settings.get((Object)setting);
        if (retVal != null) {
            return retVal;
        }
        return (String)this.settings.get((Object)Strings.toCamelCase(setting));
    }

    @Override
    public String get(String setting, String defaultValue) {
        String retVal = (String)this.settings.get((Object)setting);
        return retVal == null ? defaultValue : retVal;
    }

    @Override
    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return Booleans.parseBoolean(this.get(setting), defaultValue);
    }

    @Override
    public TimeValue getAsTime(String setting, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.get(setting), defaultValue);
    }

    @Override
    public ByteSizeValue getAsBytesSize(String setting, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(setting), defaultValue);
    }

    @Override
    public SizeValue getAsSize(String setting, SizeValue defaultValue) throws SettingsException {
        return SizeValue.parseSizeValue(this.get(setting), defaultValue);
    }

    @Override
    public <T> Class<? extends T> getAsClass(String setting, Class<? extends T> defaultClazz) throws NoClassSettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultClazz;
        }
        try {
            return this.getClassLoader().loadClass(sValue);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassSettingsException("Failed to load class setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public <T> Class<? extends T> getAsClass(String setting, Class<? extends T> defaultClazz, String prefixPackage, String suffixClassName) throws NoClassSettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultClazz;
        }
        String fullClassName = sValue;
        try {
            return this.getClassLoader().loadClass(fullClassName);
        }
        catch (ClassNotFoundException e) {
            fullClassName = prefixPackage + Strings.capitalize(Strings.toCamelCase(sValue)) + suffixClassName;
            try {
                return this.getClassLoader().loadClass(fullClassName);
            }
            catch (ClassNotFoundException e1) {
                fullClassName = prefixPackage + Strings.toCamelCase(sValue).toLowerCase() + "." + Strings.capitalize(Strings.toCamelCase(sValue)) + suffixClassName;
                try {
                    return this.getClassLoader().loadClass(fullClassName);
                }
                catch (ClassNotFoundException e2) {
                    throw new NoClassSettingsException("Failed to load class setting [" + setting + "] with value [" + sValue + "]", e);
                }
            }
        }
    }

    @Override
    public String[] getAsArray(String settingPrefix) throws SettingsException {
        return this.getAsArray(settingPrefix, Strings.EMPTY_ARRAY);
    }

    @Override
    public String[] getAsArray(String settingPrefix, String[] defaultArray) throws SettingsException {
        String value;
        ArrayList result = Lists.newArrayList();
        if (this.get(settingPrefix) != null) {
            Collections.addAll(result, Strings.commaDelimitedListToStringArray(this.get(settingPrefix)));
        }
        int counter = 0;
        while ((value = this.get(settingPrefix + '.' + counter++)) != null) {
            result.add(value);
        }
        if (result.isEmpty()) {
            return defaultArray;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        LinkedHashMap<String, LinkedHashMap<String, String>> map = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (Object o : this.settings.keySet()) {
            String setting = (String)o;
            if (!setting.startsWith(settingPrefix)) continue;
            String nameValue = setting.substring(settingPrefix.length());
            int dotIndex = nameValue.indexOf(46);
            if (dotIndex == -1) {
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + setting + "] because of a missing '.'");
            }
            String name = nameValue.substring(0, dotIndex);
            String value = nameValue.substring(dotIndex + 1);
            LinkedHashMap<String, String> groupSettings = (LinkedHashMap<String, String>)map.get(name);
            if (groupSettings == null) {
                groupSettings = new LinkedHashMap<String, String>();
                map.put(name, groupSettings);
            }
            groupSettings.put(value, this.get(setting));
        }
        LinkedHashMap retVal = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            retVal.put(entry.getKey(), new ImmutableSettings(Collections.unmodifiableMap((Map)entry.getValue()), this.classLoader));
        }
        return Collections.unmodifiableMap(retVal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSettings that = (ImmutableSettings)o;
        if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
            return false;
        }
        return !(this.settings != null ? !this.settings.equals(that.settings) : that.settings != null);
    }

    public int hashCode() {
        int result = this.settings != null ? this.settings.hashCode() : 0;
        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        return result;
    }

    private static ClassLoader buildClassLoader() {
        return Classes.getDefaultClassLoader();
    }

    public static Builder settingsBuilder() {
        return new Builder();
    }

    public static class YamlSettingsLoader {
        public static Map<String, String> load(String source) throws IOException {
            source = source.replace("\t", "  ");
            Yaml yaml = new Yaml();
            Map yamlMap = (Map)yaml.load(source);
            StringBuilder sb = new StringBuilder();
            HashMap settings = Maps.newHashMap();
            if (yamlMap == null) {
                return settings;
            }
            ArrayList path = Lists.newArrayList();
            YamlSettingsLoader.serializeMap(settings, sb, path, yamlMap);
            return settings;
        }

        public static Map<String, String> load(byte[] source) throws IOException {
            Yaml yaml = new Yaml();
            Map yamlMap = (Map)yaml.load(source.toString());
            StringBuilder sb = new StringBuilder();
            HashMap settings = Maps.newHashMap();
            if (yamlMap == null) {
                return settings;
            }
            ArrayList path = Lists.newArrayList();
            YamlSettingsLoader.serializeMap(settings, sb, path, yamlMap);
            return settings;
        }

        private static void serializeMap(Map<String, String> settings, StringBuilder sb, List<String> path, Map<Object, Object> yamlMap) {
            for (Map.Entry<Object, Object> entry : yamlMap.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    path.add((String)entry.getKey());
                    YamlSettingsLoader.serializeMap(settings, sb, path, (Map)entry.getValue());
                    path.remove(path.size() - 1);
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    path.add((String)entry.getKey());
                    YamlSettingsLoader.serializeList(settings, sb, path, (List)entry.getValue());
                    path.remove(path.size() - 1);
                    continue;
                }
                YamlSettingsLoader.serializeValue(settings, sb, path, (String)entry.getKey(), entry.getValue());
            }
        }

        private static void serializeList(Map<String, String> settings, StringBuilder sb, List<String> path, List yamlList) {
            int counter = 0;
            for (Object listEle : yamlList) {
                if (listEle instanceof Map) {
                    path.add(Integer.toString(counter));
                    YamlSettingsLoader.serializeMap(settings, sb, path, (Map)listEle);
                    path.remove(path.size() - 1);
                } else if (listEle instanceof List) {
                    path.add(Integer.toString(counter));
                    YamlSettingsLoader.serializeList(settings, sb, path, (List)listEle);
                    path.remove(path.size() - 1);
                } else {
                    YamlSettingsLoader.serializeValue(settings, sb, path, Integer.toString(counter), listEle);
                }
                ++counter;
            }
        }

        private static void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path, String name, Object value) {
            if (value == null) {
                return;
            }
            sb.setLength(0);
            for (String pathEle : path) {
                sb.append(pathEle).append('.');
            }
            sb.append(name);
            settings.put(sb.toString(), value.toString());
        }
    }

    public static class Builder
    implements Settings.Builder {
        public static final Settings EMPTY_SETTINGS = new Builder().build();
        private final Map<String, String> map = new LinkedHashMap<String, String>();
        private ClassLoader classLoader;

        private Builder() {
        }

        public Map<String, String> internalMap() {
            return this.map;
        }

        public String remove(String key) {
            return this.map.remove(key);
        }

        public String get(String key) {
            String retVal = this.map.get(key);
            if (retVal != null) {
                return retVal;
            }
            return this.map.get(Strings.toCamelCase(key));
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder put(String key, Class clazz) {
            this.map.put(key, clazz.getName());
            return this;
        }

        public Builder put(String setting, boolean value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, int value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, float value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, double value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value, TimeUnit timeUnit) {
            this.put(setting, timeUnit.toMillis(value));
            return this;
        }

        public Builder put(String setting, long value, ByteSizeUnit sizeUnit) {
            this.put(setting, sizeUnit.toBytes(value));
            return this;
        }

        public Builder putArray(String setting, String ... values) {
            String value;
            int counter = 0;
            while ((value = this.map.remove(setting + '.' + counter++)) != null) {
            }
            for (int i = 0; i < values.length; ++i) {
                this.put(setting + "." + i, values[i]);
            }
            return this;
        }

        public Builder put(String settingPrefix, String groupName, String[] settings, String[] values) throws SettingsException {
            if (settings.length != values.length) {
                throw new SettingsException("The settings length must match the value length");
            }
            for (int i = 0; i < settings.length; ++i) {
                if (values[i] == null) continue;
                this.put(settingPrefix + "." + groupName + "." + settings[i], values[i]);
            }
            return this;
        }

        public Builder put(Settings settings) {
            this.map.putAll((Map<String, String>)settings.getAsMap());
            return this;
        }

        public Builder put(Map<String, String> settings) {
            this.map.putAll(settings);
            return this;
        }

        public Builder put(Properties properties) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.map.put((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public Builder loadFromSource(String source) {
            try {
                Map<String, String> loadedSettings = YamlSettingsLoader.load(source);
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]");
            }
            return this;
        }

        public Builder loadFromUrl(URL url) throws SettingsException {
            try {
                return this.loadFromStream(url.toExternalForm(), url.openStream());
            }
            catch (IOException e) {
                throw new SettingsException("Failed to open stream for url [" + url.toExternalForm() + "]", e);
            }
        }

        public Builder loadFromStream(String resourceName, InputStream is) throws SettingsException {
            try {
                Map<String, String> loadedSettings = YamlSettingsLoader.load(Streams.copyToString(new InputStreamReader(is, "UTF-8")));
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + resourceName + "]", e);
            }
            return this;
        }

        public Builder loadFromClasspath(String resourceName) throws SettingsException {
            InputStream is;
            ClassLoader classLoader = this.classLoader;
            if (classLoader == null) {
                classLoader = ImmutableSettings.buildClassLoader();
            }
            if ((is = classLoader.getResourceAsStream(resourceName)) == null) {
                return this;
            }
            return this.loadFromStream(resourceName, is);
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder replacePropertyPlaceholders() {
            PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder("${", "}", false);
            PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    String value = System.getProperty(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    value = System.getenv(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    return (String)map.get(placeholderName);
                }
            };
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                this.map.put(entry.getKey(), propertyPlaceholder.replacePlaceholders(entry.getValue(), placeholderResolver));
            }
            return this;
        }

        public Builder putProperties(String prefix, Properties properties) {
            for (Object key1 : properties.keySet()) {
                String key = (String)key1;
                String value = properties.getProperty(key);
                if (!key.startsWith(prefix)) continue;
                this.map.put(key.substring(prefix.length()), value);
            }
            return this;
        }

        @Override
        public Settings build() {
            return new ImmutableSettings(Collections.unmodifiableMap(this.map), this.classLoader);
        }
    }
}

