/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.logging.log4j;

import java.util.Map;
import java.util.Properties;
import net.csdn.common.collect.MapBuilder;
import net.csdn.common.env.Environment;
import net.csdn.common.settings.ImmutableSettings;
import net.csdn.common.settings.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import tech.mlsql.common.utils.collect.ImmutableMap;

public class LogConfigurator {
    private static boolean loaded;
    private static ImmutableMap<String, String> replacements;

    /*
     * WARNING - void declaration
     */
    public static void configure(Settings settings) {
        if (loaded) {
            return;
        }
        loaded = true;
        Environment environment = new Environment(settings);
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(settings);
        settingsBuilder.loadFromUrl(environment.resolveConfig("logging.yml")).replacePropertyPlaceholders();
        Properties props = new Properties();
        for (Map.Entry entry : settingsBuilder.build().getAsMap().entrySet()) {
            void var7_7;
            String key = (String)entry.getKey();
            String string = (String)entry.getValue();
            if (replacements.containsKey((Object)string)) {
                String string2 = (String)replacements.get((Object)string);
            }
            if (key.endsWith(".value")) {
                props.setProperty(key.substring(0, key.length() - ".value".length()), (String)var7_7);
                continue;
            }
            if (key.endsWith(".type")) {
                props.setProperty(key.substring(0, key.length() - ".type".length()), (String)var7_7);
                continue;
            }
            props.setProperty(key, (String)var7_7);
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)true);
        Configuration oldContext = context.getConfiguration();
        for (Map.Entry entry : oldContext.getProperties().entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        PropertiesConfiguration config = new PropertiesConfigurationBuilder().setConfigurationSource(ConfigurationSource.NULL_SOURCE).setRootProperties(props).setLoggerContext(context).build();
        context.setConfiguration((Configuration)config);
        Configurator.initialize((Configuration)config);
    }

    static {
        replacements = new MapBuilder<String, String>().put("console", "org.apache.logging.log4j.core.appender.WriterAppender").put("async", "org.apache.logging.log4j.core.appender.AsyncAppender").put("dailyRollingFile", "org.apache.logging.log4j.core.appender.RollingFileAppender").put("file", "org.apache.logging.log4j.core.appender.FileAppender").put("hadoo", "org.apache.logging.log4j.core.appender.FileAppender").put("jdbc", "org.apache.logging.log4j.core.appender.db.jdbc.JDBCAppender").put("jms", "org.apache.logging.log4j.core.appender.mom.JMSAppender").put("null", "org.apache.logging.log4j.core.appender.NullAppender").put("rollingFile", "org.apache.logging.log4j.core.appender.RollingFileAppender").put("smtp", "org.apache.logging.log4j.core.appender.SMTPAppender").put("socket", "org.apache.logging.log4j.core.appender.SocketAppender").put("socketHub", "org.apache.logging.log4j.core.appender.SocketHubAppender").put("syslog", "org.apache.logging.log4j.core.appender.SyslogAppender").put("simple", "org.apache.logging.log4j.core.layout.SyslogLayout").put("html", "org.apache.logging.log4j.core.layout.HtmlLayout").put("pattern", "org.apache.logging.log4j.core.layout.PatternLayout").put("consolePattern", "org.apache.logging.log4j.core.layout.PatternLayout").put("xml", "org.apache.logging.log4j.core.layout.XmlLayout").immutableMap();
    }
}

