/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.unit;

import java.io.Serializable;
import net.csdn.common.Strings;
import net.csdn.common.exception.ParseException;
import net.csdn.common.unit.ByteSizeUnit;

public class ByteSizeValue
implements Serializable {
    private long size;
    private ByteSizeUnit sizeUnit;

    private ByteSizeValue() {
    }

    public ByteSizeValue(long bytes) {
        this(bytes, ByteSizeUnit.BYTES);
    }

    public ByteSizeValue(long size, ByteSizeUnit sizeUnit) {
        this.size = size;
        this.sizeUnit = sizeUnit;
    }

    public long bytes() {
        return this.sizeUnit.toBytes(this.size);
    }

    public long getBytes() {
        return this.bytes();
    }

    public long kb() {
        return this.sizeUnit.toKB(this.size);
    }

    public long getKb() {
        return this.kb();
    }

    public long mb() {
        return this.sizeUnit.toMB(this.size);
    }

    public long getMb() {
        return this.mb();
    }

    public long gb() {
        return this.sizeUnit.toGB(this.size);
    }

    public long getGb() {
        return this.gb();
    }

    public double kbFrac() {
        return (double)this.bytes() / 1024.0;
    }

    public double getKbFrac() {
        return this.kbFrac();
    }

    public double mbFrac() {
        return (double)this.bytes() / 1048576.0;
    }

    public double getMbFrac() {
        return this.mbFrac();
    }

    public double gbFrac() {
        return (double)this.bytes() / 1.073741824E9;
    }

    public double getGbFrac() {
        return this.gbFrac();
    }

    public String toString() {
        long bytes = this.bytes();
        double value = bytes;
        String suffix = "b";
        if (bytes >= 0x40000000L) {
            value = this.gbFrac();
            suffix = "gb";
        } else if (bytes >= 0x100000L) {
            value = this.mbFrac();
            suffix = "mb";
        } else if (bytes >= 1024L) {
            value = this.kbFrac();
            suffix = "kb";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue) throws ParseException {
        return ByteSizeValue.parseBytesSizeValue(sValue, null);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue, ByteSizeValue defaultValue) throws ParseException {
        long bytes;
        if (sValue == null) {
            return defaultValue;
        }
        try {
            bytes = sValue.endsWith("k") || sValue.endsWith("K") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1024.0) : (sValue.endsWith("kb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1024.0) : (sValue.endsWith("m") || sValue.endsWith("M") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1048576.0) : (sValue.endsWith("mb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1048576.0) : (sValue.endsWith("g") || sValue.endsWith("G") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1.073741824E9) : (sValue.endsWith("gb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1.073741824E9) : (sValue.endsWith("b") ? Long.parseLong(sValue.substring(0, sValue.length() - 1)) : Long.parseLong(sValue)))))));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Failed to parse [" + sValue + "]", e);
        }
        return new ByteSizeValue(bytes, ByteSizeUnit.BYTES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteSizeValue sizeValue = (ByteSizeValue)o;
        if (this.size != sizeValue.size) {
            return false;
        }
        return this.sizeUnit == sizeValue.sizeUnit;
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.sizeUnit != null ? this.sizeUnit.hashCode() : 0);
        return result;
    }
}

