/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.http.server;

import java.io.IOException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer {
    public ServerConnector createConnector(Server server, String host, int port) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        connector.setPort(port);
        connector.setHost(host);
        return connector;
    }

    public Server connfigureServer(Server server, String staticDir, String templateDir, boolean staticEnable, boolean classPathEnable, boolean sessionEanble, AbstractHandler abstractHandler) {
        HandlerList handlers = new HandlerList();
        if (staticEnable) {
            ResourceHandler resource_handler = new ResourceHandler();
            resource_handler.setDirectoriesListed(false);
            try {
                if (classPathEnable) {
                    String webDir = this.getClass().getClassLoader().getResource(staticDir).toExternalForm();
                    resource_handler.setBaseResource(Resource.newResource((String)webDir));
                } else {
                    resource_handler.setBaseResource(Resource.newResource((String)(templateDir + "/" + staticDir + "/")));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (sessionEanble) {
                HashSessionManager sessionManager = new HashSessionManager();
                sessionManager.setSessionIdPathParameterName("none");
                handlers.setHandlers(new Handler[]{resource_handler, new SessionHandler((SessionManager)sessionManager), abstractHandler});
            } else {
                handlers.setHandlers(new Handler[]{resource_handler, abstractHandler});
            }
        } else {
            handlers.setHandlers(new Handler[]{abstractHandler});
        }
        server.setHandler((Handler)handlers);
        return server;
    }

    public Server createServer(int minThreads, int maxThreads) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(minThreads);
        threadPool.setMaxThreads(maxThreads);
        Server server = new Server((ThreadPool)threadPool);
        return server;
    }
}

