/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.api.controller;

import com.google.inject.Inject;
import java.util.Collection;
import net.csdn.annotation.rest.At;
import net.csdn.common.collections.WowCollections;
import net.csdn.modules.controller.API;
import net.csdn.modules.controller.APIDesc;
import net.csdn.modules.controller.QpsManager;
import net.csdn.modules.http.ApplicationController;
import net.csdn.modules.http.RestRequest;

public class SystemInfoController
extends ApplicationController {
    @Inject
    private API api;
    @Inject
    private QpsManager qpsManager;

    @At(path={"/service/monitor"}, types={RestRequest.Method.GET, RestRequest.Method.POST})
    public void systemInfo() {
        if (!this.api.enable()) {
            this.render(this.map("ok", false, "message", "\u8be5\u670d\u52a1\u6ca1\u6709\u542f\u7528\u3002\u53ef\u901a\u8fc7\u8bbe\u7f6eapplication.api.qps.enable \u8fdb\u884c\u8bbe\u7f6e"));
        }
        Collection<APIDesc> apiDescs = this.api.collectAPIInfoes().values();
        for (APIDesc apiDesc : apiDescs) {
            apiDesc.setQps(apiDesc.getQps() * 1000L / (long)this.settings.getAsInt("application.api.qps.internal", Integer.valueOf(1000)).intValue());
        }
        this.render(WowCollections.map((Object[])new Object[]{"systemStartTime", this.api.systemStartTime(), "api", apiDescs}));
    }

    @At(path={"/service/qps/limit"}, types={RestRequest.Method.POST})
    public void qpsLimit() {
        if (!this.api.enable()) {
            this.render(this.map("ok", false, "message", "\u8be5\u670d\u52a1\u6ca1\u6709\u542f\u7528\u3002\u53ef\u901a\u8fc7\u8bbe\u7f6eapplication.api.qps.enable \u8fdb\u884c\u8bbe\u7f6e"));
        }
        this.qpsManager.configureQpsLimiter(this.params());
        this.render(200, this.qpsManager.qpsConfs());
    }
}

