/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.thrift;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.csdn.ServiceFramwork;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;

@Singleton
public class ThriftServer {
    private CSLogger logger = Loggers.getLogger(this.getClass());
    private Settings settings;
    private List<TServer> servers = new ArrayList<TServer>();
    private static final String prefix = "thrift.services";

    @Inject
    public ThriftServer(Settings settings) {
        this.settings = settings;
        boolean disableThrift = settings.getAsBoolean("thrift.disable", Boolean.valueOf(false));
        if (disableThrift || ServiceFramwork.mode.equals((Object)ServiceFramwork.Mode.test)) {
            return;
        }
        ImmutableMap services = settings.getByPrefix("thrift.services.").getAsMap();
        HashMap<String, Map> newServices = new HashMap<String, Map>();
        for (Map.Entry entry : services.entrySet()) {
            String[] split = ((String)entry.getKey()).split("\\.");
            String className = split[0].replaceAll("_", ".");
            if (split.length <= 1) continue;
            if (newServices.containsKey(className)) {
                ((Map)newServices.get(className)).put(((String)entry.getKey()).substring(className.length()), entry.getValue());
                continue;
            }
            newServices.put(className, WowCollections.map((Object[])new Object[]{((String)entry.getKey()).substring(className.length()), entry.getValue()}));
        }
        for (Map.Entry entry : newServices.entrySet()) {
            try {
                String impClassName = (String)entry.getKey();
                String parent = (String)((Map)entry.getValue()).get(".interface");
                Class<?> clzz = Class.forName(impClassName);
                if (parent == null) {
                    Class<?>[] inters;
                    for (Class<?> iter : inters = clzz.getInterfaces()) {
                        if (!iter.getName().endsWith("Iface")) continue;
                        parent = clzz.getInterfaces()[0].getName();
                    }
                }
                Class<?> processor = Class.forName(parent.split("\\$")[0] + "$Processor");
                this.servers.add((TServer)new TThreadPoolServer(((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)new TServerSocket(Integer.parseInt((String)((Map)entry.getValue()).get(".port")))).protocolFactory((TProtocolFactory)new TCompactProtocol.Factory())).processor((TProcessor)processor.getConstructor(Class.forName(parent)).newInstance(clzz.newInstance()))).minWorkerThreads(Integer.parseInt((String)((Map)entry.getValue()).get(".min_threads"))).maxWorkerThreads(Integer.parseInt((String)((Map)entry.getValue()).get(".max_threads")))));
                this.logger.info("start [" + impClassName + "] server on port " + (String)((Map)entry.getValue()).get(".port"), new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        for (final TServer tServer : this.servers) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    tServer.serve();
                }
            }).start();
        }
    }

    public void stop() {
        for (TServer tServer : this.servers) {
            tServer.stop();
        }
    }
}

