/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird;

import java.util.concurrent.ConcurrentHashMap;
import net.csibio.aird.parser.BaseParser;

public class AirdManager {
    public static AirdManager instance = new AirdManager();
    public ConcurrentHashMap<String, BaseParser> parserMap = new ConcurrentHashMap();

    private AirdManager() {
    }

    public static AirdManager getInstance() {
        return instance;
    }

    public BaseParser load(String indexPath) {
        BaseParser parser = BaseParser.buildParser(indexPath);
        this.parserMap.put(indexPath, parser);
        return parser;
    }

    public BaseParser load(String indexPath, String indexId) {
        BaseParser parser = BaseParser.buildParser(indexPath);
        this.parserMap.put(indexId, parser);
        return parser;
    }

    public BaseParser getParser(String indexPath) {
        return this.parserMap.get(indexPath);
    }

    public BaseParser touchParser(String indexPath) {
        BaseParser parser = this.parserMap.get(indexPath);
        if (parser == null) {
            return this.load(indexPath);
        }
        return parser;
    }

    public void removeParser(String indexPath) {
        this.parserMap.remove(indexPath);
    }

    public void clearParser() {
        this.parserMap.values().forEach(BaseParser::close);
        this.parserMap.clear();
    }
}

