/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import net.csibio.aird.bean.BlockIndex;
import net.csibio.aird.bean.Compressor;
import net.csibio.aird.bean.DataProcessing;
import net.csibio.aird.bean.Instrument;
import net.csibio.aird.bean.ParentFile;
import net.csibio.aird.bean.Software;
import net.csibio.aird.bean.WindowRange;
import net.csibio.aird.enums.MsLevel;

public class AirdInfo {
    List<Compressor> compressors;
    String version = "1.0.4";
    Integer versionCode = 4;
    List<WindowRange> rangeList = new ArrayList<WindowRange>();
    List<BlockIndex> indexList;
    @Deprecated
    List<BlockIndex> blockIndexList;
    List<Instrument> instruments;
    List<DataProcessing> dataProcessings;
    List<Software> softwares;
    List<ParentFile> parentFiles;
    String type;
    Long fileSize;
    Long totalScanCount;
    String airdPath;
    String description;
    String creator;
    String createDate;
    Boolean ignoreZeroIntensityPoint = true;
    String msType;
    String polarity;
    String activator;
    Float energy;
    String rtUnit;
    String features;

    public Compressor fetchCompressor(String target) {
        if (this.compressors == null) {
            return null;
        }
        for (int i = 0; i < this.compressors.size(); ++i) {
            if (!this.compressors.get(i).getTarget().equals(target)) continue;
            return this.compressors.get(i);
        }
        return null;
    }

    public List<BlockIndex> getIndexList() {
        if (this.blockIndexList != null && this.blockIndexList.size() != 0) {
            return this.blockIndexList;
        }
        return this.indexList;
    }

    public TreeMap<Float, Long> getTicMap() {
        TreeMap<Float, Long> map = new TreeMap<Float, Long>(){};
        this.indexList.forEach(blockIndex -> {
            if (Objects.equals(blockIndex.level, MsLevel.MS1.getCode())) {
                for (int i = 0; i < blockIndex.rts.size(); ++i) {
                    map.put(blockIndex.rts.get(i), blockIndex.tics.get(i));
                }
            }
        });
        return map;
    }

    public List<Compressor> getCompressors() {
        return this.compressors;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getVersionCode() {
        return this.versionCode;
    }

    public List<WindowRange> getRangeList() {
        return this.rangeList;
    }

    @Deprecated
    public List<BlockIndex> getBlockIndexList() {
        return this.blockIndexList;
    }

    public List<Instrument> getInstruments() {
        return this.instruments;
    }

    public List<DataProcessing> getDataProcessings() {
        return this.dataProcessings;
    }

    public List<Software> getSoftwares() {
        return this.softwares;
    }

    public List<ParentFile> getParentFiles() {
        return this.parentFiles;
    }

    public String getType() {
        return this.type;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public Long getTotalScanCount() {
        return this.totalScanCount;
    }

    public String getAirdPath() {
        return this.airdPath;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public Boolean getIgnoreZeroIntensityPoint() {
        return this.ignoreZeroIntensityPoint;
    }

    public String getMsType() {
        return this.msType;
    }

    public String getPolarity() {
        return this.polarity;
    }

    public String getActivator() {
        return this.activator;
    }

    public Float getEnergy() {
        return this.energy;
    }

    public String getRtUnit() {
        return this.rtUnit;
    }

    public String getFeatures() {
        return this.features;
    }

    public void setCompressors(List<Compressor> compressors) {
        this.compressors = compressors;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersionCode(Integer versionCode) {
        this.versionCode = versionCode;
    }

    public void setRangeList(List<WindowRange> rangeList) {
        this.rangeList = rangeList;
    }

    public void setIndexList(List<BlockIndex> indexList) {
        this.indexList = indexList;
    }

    @Deprecated
    public void setBlockIndexList(List<BlockIndex> blockIndexList) {
        this.blockIndexList = blockIndexList;
    }

    public void setInstruments(List<Instrument> instruments) {
        this.instruments = instruments;
    }

    public void setDataProcessings(List<DataProcessing> dataProcessings) {
        this.dataProcessings = dataProcessings;
    }

    public void setSoftwares(List<Software> softwares) {
        this.softwares = softwares;
    }

    public void setParentFiles(List<ParentFile> parentFiles) {
        this.parentFiles = parentFiles;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setTotalScanCount(Long totalScanCount) {
        this.totalScanCount = totalScanCount;
    }

    public void setAirdPath(String airdPath) {
        this.airdPath = airdPath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public void setIgnoreZeroIntensityPoint(Boolean ignoreZeroIntensityPoint) {
        this.ignoreZeroIntensityPoint = ignoreZeroIntensityPoint;
    }

    public void setMsType(String msType) {
        this.msType = msType;
    }

    public void setPolarity(String polarity) {
        this.polarity = polarity;
    }

    public void setActivator(String activator) {
        this.activator = activator;
    }

    public void setEnergy(Float energy) {
        this.energy = energy;
    }

    public void setRtUnit(String rtUnit) {
        this.rtUnit = rtUnit;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AirdInfo)) {
            return false;
        }
        AirdInfo other = (AirdInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$versionCode = this.getVersionCode();
        Integer other$versionCode = other.getVersionCode();
        if (this$versionCode == null ? other$versionCode != null : !((Object)this$versionCode).equals(other$versionCode)) {
            return false;
        }
        Long this$fileSize = this.getFileSize();
        Long other$fileSize = other.getFileSize();
        if (this$fileSize == null ? other$fileSize != null : !((Object)this$fileSize).equals(other$fileSize)) {
            return false;
        }
        Long this$totalScanCount = this.getTotalScanCount();
        Long other$totalScanCount = other.getTotalScanCount();
        if (this$totalScanCount == null ? other$totalScanCount != null : !((Object)this$totalScanCount).equals(other$totalScanCount)) {
            return false;
        }
        Boolean this$ignoreZeroIntensityPoint = this.getIgnoreZeroIntensityPoint();
        Boolean other$ignoreZeroIntensityPoint = other.getIgnoreZeroIntensityPoint();
        if (this$ignoreZeroIntensityPoint == null ? other$ignoreZeroIntensityPoint != null : !((Object)this$ignoreZeroIntensityPoint).equals(other$ignoreZeroIntensityPoint)) {
            return false;
        }
        Float this$energy = this.getEnergy();
        Float other$energy = other.getEnergy();
        if (this$energy == null ? other$energy != null : !((Object)this$energy).equals(other$energy)) {
            return false;
        }
        List<Compressor> this$compressors = this.getCompressors();
        List<Compressor> other$compressors = other.getCompressors();
        if (this$compressors == null ? other$compressors != null : !((Object)this$compressors).equals(other$compressors)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<WindowRange> this$rangeList = this.getRangeList();
        List<WindowRange> other$rangeList = other.getRangeList();
        if (this$rangeList == null ? other$rangeList != null : !((Object)this$rangeList).equals(other$rangeList)) {
            return false;
        }
        List<BlockIndex> this$indexList = this.getIndexList();
        List<BlockIndex> other$indexList = other.getIndexList();
        if (this$indexList == null ? other$indexList != null : !((Object)this$indexList).equals(other$indexList)) {
            return false;
        }
        List<BlockIndex> this$blockIndexList = this.getBlockIndexList();
        List<BlockIndex> other$blockIndexList = other.getBlockIndexList();
        if (this$blockIndexList == null ? other$blockIndexList != null : !((Object)this$blockIndexList).equals(other$blockIndexList)) {
            return false;
        }
        List<Instrument> this$instruments = this.getInstruments();
        List<Instrument> other$instruments = other.getInstruments();
        if (this$instruments == null ? other$instruments != null : !((Object)this$instruments).equals(other$instruments)) {
            return false;
        }
        List<DataProcessing> this$dataProcessings = this.getDataProcessings();
        List<DataProcessing> other$dataProcessings = other.getDataProcessings();
        if (this$dataProcessings == null ? other$dataProcessings != null : !((Object)this$dataProcessings).equals(other$dataProcessings)) {
            return false;
        }
        List<Software> this$softwares = this.getSoftwares();
        List<Software> other$softwares = other.getSoftwares();
        if (this$softwares == null ? other$softwares != null : !((Object)this$softwares).equals(other$softwares)) {
            return false;
        }
        List<ParentFile> this$parentFiles = this.getParentFiles();
        List<ParentFile> other$parentFiles = other.getParentFiles();
        if (this$parentFiles == null ? other$parentFiles != null : !((Object)this$parentFiles).equals(other$parentFiles)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$airdPath = this.getAirdPath();
        String other$airdPath = other.getAirdPath();
        if (this$airdPath == null ? other$airdPath != null : !this$airdPath.equals(other$airdPath)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$createDate = this.getCreateDate();
        String other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !this$createDate.equals(other$createDate)) {
            return false;
        }
        String this$msType = this.getMsType();
        String other$msType = other.getMsType();
        if (this$msType == null ? other$msType != null : !this$msType.equals(other$msType)) {
            return false;
        }
        String this$polarity = this.getPolarity();
        String other$polarity = other.getPolarity();
        if (this$polarity == null ? other$polarity != null : !this$polarity.equals(other$polarity)) {
            return false;
        }
        String this$activator = this.getActivator();
        String other$activator = other.getActivator();
        if (this$activator == null ? other$activator != null : !this$activator.equals(other$activator)) {
            return false;
        }
        String this$rtUnit = this.getRtUnit();
        String other$rtUnit = other.getRtUnit();
        if (this$rtUnit == null ? other$rtUnit != null : !this$rtUnit.equals(other$rtUnit)) {
            return false;
        }
        String this$features = this.getFeatures();
        String other$features = other.getFeatures();
        return !(this$features == null ? other$features != null : !this$features.equals(other$features));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AirdInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $versionCode = this.getVersionCode();
        result = result * 59 + ($versionCode == null ? 43 : ((Object)$versionCode).hashCode());
        Long $fileSize = this.getFileSize();
        result = result * 59 + ($fileSize == null ? 43 : ((Object)$fileSize).hashCode());
        Long $totalScanCount = this.getTotalScanCount();
        result = result * 59 + ($totalScanCount == null ? 43 : ((Object)$totalScanCount).hashCode());
        Boolean $ignoreZeroIntensityPoint = this.getIgnoreZeroIntensityPoint();
        result = result * 59 + ($ignoreZeroIntensityPoint == null ? 43 : ((Object)$ignoreZeroIntensityPoint).hashCode());
        Float $energy = this.getEnergy();
        result = result * 59 + ($energy == null ? 43 : ((Object)$energy).hashCode());
        List<Compressor> $compressors = this.getCompressors();
        result = result * 59 + ($compressors == null ? 43 : ((Object)$compressors).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<WindowRange> $rangeList = this.getRangeList();
        result = result * 59 + ($rangeList == null ? 43 : ((Object)$rangeList).hashCode());
        List<BlockIndex> $indexList = this.getIndexList();
        result = result * 59 + ($indexList == null ? 43 : ((Object)$indexList).hashCode());
        List<BlockIndex> $blockIndexList = this.getBlockIndexList();
        result = result * 59 + ($blockIndexList == null ? 43 : ((Object)$blockIndexList).hashCode());
        List<Instrument> $instruments = this.getInstruments();
        result = result * 59 + ($instruments == null ? 43 : ((Object)$instruments).hashCode());
        List<DataProcessing> $dataProcessings = this.getDataProcessings();
        result = result * 59 + ($dataProcessings == null ? 43 : ((Object)$dataProcessings).hashCode());
        List<Software> $softwares = this.getSoftwares();
        result = result * 59 + ($softwares == null ? 43 : ((Object)$softwares).hashCode());
        List<ParentFile> $parentFiles = this.getParentFiles();
        result = result * 59 + ($parentFiles == null ? 43 : ((Object)$parentFiles).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $airdPath = this.getAirdPath();
        result = result * 59 + ($airdPath == null ? 43 : $airdPath.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : $createDate.hashCode());
        String $msType = this.getMsType();
        result = result * 59 + ($msType == null ? 43 : $msType.hashCode());
        String $polarity = this.getPolarity();
        result = result * 59 + ($polarity == null ? 43 : $polarity.hashCode());
        String $activator = this.getActivator();
        result = result * 59 + ($activator == null ? 43 : $activator.hashCode());
        String $rtUnit = this.getRtUnit();
        result = result * 59 + ($rtUnit == null ? 43 : $rtUnit.hashCode());
        String $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : $features.hashCode());
        return result;
    }

    public String toString() {
        return "AirdInfo(compressors=" + this.getCompressors() + ", version=" + this.getVersion() + ", versionCode=" + this.getVersionCode() + ", rangeList=" + this.getRangeList() + ", indexList=" + this.getIndexList() + ", blockIndexList=" + this.getBlockIndexList() + ", instruments=" + this.getInstruments() + ", dataProcessings=" + this.getDataProcessings() + ", softwares=" + this.getSoftwares() + ", parentFiles=" + this.getParentFiles() + ", type=" + this.getType() + ", fileSize=" + this.getFileSize() + ", totalScanCount=" + this.getTotalScanCount() + ", airdPath=" + this.getAirdPath() + ", description=" + this.getDescription() + ", creator=" + this.getCreator() + ", createDate=" + this.getCreateDate() + ", ignoreZeroIntensityPoint=" + this.getIgnoreZeroIntensityPoint() + ", msType=" + this.getMsType() + ", polarity=" + this.getPolarity() + ", activator=" + this.getActivator() + ", energy=" + this.getEnergy() + ", rtUnit=" + this.getRtUnit() + ", features=" + this.getFeatures() + ")";
    }
}

