/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.bean;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Compressor {
    public static String TARGET_MZ = "mz";
    public static String TARGET_INTENSITY = "intensity";
    public static String METHOD_ZLIB = "zlib";
    public static String METHOD_STACK = "stack";
    public static String METHOD_PFOR = "pFor";
    public static String METHOD_LOG10 = "log10";
    public static int PRECISION_MZ = 10000;
    public static int PRECISION_INT = 10;
    String target;
    List<String> methods;
    @Deprecated
    String method;
    Integer precision;
    Integer digit;
    String byteOrder;

    public Integer getPrecision() {
        if (this.precision != null) {
            return this.precision;
        }
        if (this.target.equals(TARGET_MZ)) {
            return 1000;
        }
        if (this.target.equals(TARGET_INTENSITY)) {
            return 10;
        }
        return null;
    }

    public ByteOrder fetchByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public List<String> getMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        if (this.method != null) {
            String[] methodArray = this.method.split(",");
            return Arrays.asList(methodArray);
        }
        return new ArrayList<String>();
    }

    public String getTarget() {
        return this.target;
    }

    @Deprecated
    public String getMethod() {
        return this.method;
    }

    public Integer getDigit() {
        return this.digit;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    @Deprecated
    public void setMethod(String method) {
        this.method = method;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setDigit(Integer digit) {
        this.digit = digit;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Compressor)) {
            return false;
        }
        Compressor other = (Compressor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Integer this$digit = this.getDigit();
        Integer other$digit = other.getDigit();
        if (this$digit == null ? other$digit != null : !((Object)this$digit).equals(other$digit)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<String> this$methods = this.getMethods();
        List<String> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$byteOrder = this.getByteOrder();
        String other$byteOrder = other.getByteOrder();
        return !(this$byteOrder == null ? other$byteOrder != null : !this$byteOrder.equals(other$byteOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Compressor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Integer $digit = this.getDigit();
        result = result * 59 + ($digit == null ? 43 : ((Object)$digit).hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<String> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $byteOrder = this.getByteOrder();
        result = result * 59 + ($byteOrder == null ? 43 : $byteOrder.hashCode());
        return result;
    }

    public String toString() {
        return "Compressor(target=" + this.getTarget() + ", methods=" + this.getMethods() + ", method=" + this.getMethod() + ", precision=" + this.getPrecision() + ", digit=" + this.getDigit() + ", byteOrder=" + this.getByteOrder() + ")";
    }
}

