/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.compressor;

import net.csibio.aird.compressor.CompressorType;
import net.csibio.aird.compressor.bytes.Brotli;
import net.csibio.aird.compressor.bytes.Gzip;
import net.csibio.aird.compressor.bytes.LZ4;
import net.csibio.aird.compressor.bytes.LZMA2;
import net.csibio.aird.compressor.bytes.Snappier;
import net.csibio.aird.compressor.bytes.Zlib;

public class ByteCompressor {
    CompressorType compressorType;

    public ByteCompressor(CompressorType type) {
        this.compressorType = type;
    }

    public byte[] encode(byte[] bytes) {
        return switch (this.compressorType) {
            case CompressorType.Zlib -> Zlib.encode(bytes);
            case CompressorType.LZMA2 -> LZMA2.encode(bytes);
            case CompressorType.Gzip -> Gzip.encode(bytes);
            case CompressorType.Snappy -> Snappier.encode(bytes);
            case CompressorType.Brotli -> Brotli.encode(bytes);
            case CompressorType.LZ4 -> LZ4.encode(bytes);
            default -> null;
        };
    }

    public byte[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public byte[] decode(byte[] bytes, int start, int length) {
        return switch (this.compressorType) {
            case CompressorType.Zlib -> Zlib.decode(bytes, start, length);
            case CompressorType.LZMA2 -> LZMA2.decode(bytes, start, length);
            case CompressorType.Gzip -> Gzip.decode(bytes, start, length);
            case CompressorType.Snappy -> Snappier.decode(bytes, start, length);
            case CompressorType.Brotli -> Brotli.decode(bytes, start, length);
            default -> null;
        };
    }
}

