/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.compressor.bytes;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.csibio.aird.util.FileUtil;

public class Gzip {
    static int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] encode(byte[] input) {
        byte[] byArray;
        ByteArrayInputStream in = null;
        ByteArrayOutputStream out = null;
        GZIPOutputStream outputStream = null;
        try {
            int size;
            in = new ByteArrayInputStream(input);
            out = new ByteArrayOutputStream();
            outputStream = new GZIPOutputStream(out);
            byte[] buf = new byte[BUFFER_SIZE];
            while ((size = in.read(buf)) != -1) {
                outputStream.write(buf, 0, size);
            }
            outputStream.finish();
            byArray = out.toByteArray();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(outputStream);
                FileUtil.close(in);
                FileUtil.close(out);
                throw throwable;
            }
            FileUtil.close(outputStream);
            FileUtil.close(in);
            FileUtil.close(out);
            return null;
        }
        FileUtil.close(outputStream);
        FileUtil.close(in);
        FileUtil.close(out);
        return byArray;
    }

    public static byte[] decode(byte[] input) {
        return Gzip.decode(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(byte[] input, int offset, int length) {
        block6: {
            byte[] byArray;
            ByteArrayInputStream in = new ByteArrayInputStream(input, offset, length);
            BufferedInputStream inBuffer = new BufferedInputStream(in);
            ByteArrayOutputStream out = null;
            GZIPInputStream inputStream = null;
            try {
                int size;
                out = new ByteArrayOutputStream();
                inputStream = new GZIPInputStream(inBuffer);
                byte[] buf = new byte[BUFFER_SIZE];
                while ((size = inputStream.read(buf)) != -1) {
                    out.write(buf, 0, size);
                }
                byArray = out.toByteArray();
                FileUtil.close(inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                FileUtil.close(inputStream);
                FileUtil.close(out);
            }
            FileUtil.close(out);
            return byArray;
        }
        return null;
    }
}

