/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.compressor.ints;

import net.csibio.aird.compressor.ByteCompressor;
import net.csibio.aird.compressor.ByteTrans;
import net.csibio.aird.compressor.CompressorType;
import net.csibio.aird.compressor.ints.FastPFor;

public class XDPD {
    public static byte[] encode(int[] sortedInts) {
        return XDPD.encode(sortedInts, CompressorType.Zlib);
    }

    public static byte[] encode(int[] sortedInts, CompressorType byteCompType) {
        int[] compressedInts = FastPFor.encode(sortedInts);
        byte[] bytes = ByteTrans.intToByte(compressedInts);
        return new ByteCompressor(byteCompType).encode(bytes);
    }

    public static byte[] encode(double[] sortedFloats, double precision, CompressorType byteCompType) {
        int[] sortedInts = new int[sortedFloats.length];
        for (int i = 0; i < sortedFloats.length; ++i) {
            sortedInts[i] = (int)(precision * sortedFloats[i]);
        }
        return XDPD.encode(sortedInts, byteCompType);
    }

    public static double[] decode(byte[] bytes, int precision) {
        return XDPD.decode(bytes, precision, CompressorType.Zlib);
    }

    public static double[] decode(byte[] bytes, double precision, CompressorType type) {
        byte[] decodeBytes = new ByteCompressor(type).decode(bytes);
        int[] zipInts = ByteTrans.byteToInt(decodeBytes);
        int[] sortedInts = FastPFor.decode(zipInts);
        double[] sortedDouble = new double[sortedInts.length];
        for (int i = 0; i < sortedInts.length; ++i) {
            sortedDouble[i] = (double)sortedInts[i] / precision;
        }
        return sortedDouble;
    }
}

