/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.eic;

import java.util.List;
import net.csibio.aird.bean.MzIntensityPairs;
import net.csibio.aird.opencl.XIC;

public class Extractor {
    public static float accumulation(MzIntensityPairs pairs, Float mzStart, Float mzEnd) {
        double[] mzArray = pairs.getMzArray();
        float[] intensityArray = pairs.getIntensityArray();
        float result = 0.0f;
        try {
            int index = Extractor.lowerBound(mzArray, mzStart);
            if (index == -1) {
                return 0.0f;
            }
            int iterIndex = index;
            while (mzArray[iterIndex] <= (double)mzEnd.floatValue()) {
                result += intensityArray[iterIndex];
                ++iterIndex;
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static float[][] accumulationWithGPU(List<MzIntensityPairs> pairsList, float[] targetMzArray, float mzWindow) {
        float[][] resMatrix = new float[pairsList.size()][targetMzArray.length];
        int countInBatch = 5;
        int delta = countInBatch - pairsList.size() % countInBatch;
        if (delta != countInBatch) {
            for (int k = 0; k < delta; ++k) {
                pairsList.add(new MzIntensityPairs(new double[0], new float[0]));
            }
        }
        XIC.initialize(countInBatch);
        for (int i = 0; i < pairsList.size(); i += countInBatch) {
            float[] results = XIC.lowerBoundWithGPU(pairsList.subList(i, i + countInBatch), targetMzArray, mzWindow);
            resMatrix[i] = results;
        }
        XIC.shutdown();
        return resMatrix;
    }

    public static int lowerBound(float[] array, Float target) {
        int high = array.length - 1;
        if (target.floatValue() <= array[0]) {
            return 0;
        }
        if (target.floatValue() >= array[high]) {
            return -1;
        }
        int low = 0;
        while (low + 1 < high) {
            int mid = low + high >>> 1;
            if (target.floatValue() < array[mid]) {
                high = mid;
                continue;
            }
            if (target.floatValue() > array[mid]) {
                low = mid;
                continue;
            }
            return mid;
        }
        return high;
    }

    public static int lowerBound(double[] array, Float target) {
        int high = array.length - 1;
        if ((double)target.floatValue() <= array[0]) {
            return 0;
        }
        if ((double)target.floatValue() >= array[high]) {
            return -1;
        }
        int low = 0;
        while (low + 1 < high) {
            int mid = low + high >>> 1;
            if ((double)target.floatValue() < array[mid]) {
                high = mid;
                continue;
            }
            if ((double)target.floatValue() > array[mid]) {
                low = mid;
                continue;
            }
            return mid;
        }
        return high;
    }
}

