/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.opencl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.csibio.aird.bean.MzIntensityPairs;
import org.jocl.CL;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_platform_id;
import org.jocl.cl_program;
import org.jocl.cl_queue_properties;

public class XIC {
    private static cl_context context;
    private static cl_command_queue commandQueue;
    private static cl_program program;
    private static cl_kernel kernel;

    public static float[] lowerBoundWithGPU(List<MzIntensityPairs> pairsList, float[] targets, float mzWindow) {
        int countInBatch = pairsList.size();
        float[] results = new float[targets.length * countInBatch];
        cl_mem targetsMem = CL.clCreateBuffer((cl_context)context, (long)36L, (long)(4 * targets.length), (Pointer)Pointer.to((float[])targets), null);
        ArrayList<Spectrum> paramsList = new ArrayList<Spectrum>();
        for (int i = 0; i < countInBatch; ++i) {
            double[] mzArray = pairsList.get(i).getMzArray();
            if (mzArray.length == 0) {
                paramsList.add(null);
                continue;
            }
            paramsList.add(new Spectrum(CL.clCreateBuffer((cl_context)context, (long)36L, (long)(4 * pairsList.get(i).getMzArray().length), (Pointer)Pointer.to((double[])pairsList.get(i).getMzArray()), null), CL.clCreateBuffer((cl_context)context, (long)36L, (long)(4 * pairsList.get(i).getIntensityArray().length), (Pointer)Pointer.to((float[])pairsList.get(i).getIntensityArray()), null), pairsList.get(i).getMzArray().length));
        }
        cl_mem resultsMem = CL.clCreateBuffer((cl_context)context, (long)34L, (long)(4 * targets.length * countInBatch), (Pointer)Pointer.to((float[])results), null);
        XIC.lowerBound(paramsList, targetsMem, targets.length, resultsMem, mzWindow);
        CL.clEnqueueReadBuffer((cl_command_queue)commandQueue, (cl_mem)resultsMem, (boolean)true, (long)0L, (long)(targets.length * 4), (Pointer)Pointer.to((float[])results), (int)0, null, null);
        paramsList.forEach(params -> {
            if (params != null) {
                CL.clReleaseMemObject((cl_mem)params.getMzArrayMem());
                CL.clReleaseMemObject((cl_mem)params.getIntArrayMem());
            }
        });
        CL.clReleaseMemObject((cl_mem)targetsMem);
        CL.clReleaseMemObject((cl_mem)resultsMem);
        return results;
    }

    private static void lowerBound(List<Spectrum> xicParamsList, cl_mem targetsMem, int targetsLength, cl_mem resultsMem, float mzWindow) {
        int a = 0;
        CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)targetsMem));
        CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)4L, (Pointer)Pointer.to((int[])new int[]{targetsLength}));
        for (int i = 0; i < xicParamsList.size(); ++i) {
            if (xicParamsList.get(i) != null) {
                CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)xicParamsList.get(i).getMzArrayMem()));
                CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)xicParamsList.get(i).getIntArrayMem()));
                CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)4L, (Pointer)Pointer.to((int[])new int[]{xicParamsList.get(i).getLength()}));
                continue;
            }
            CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)Sizeof.cl_mem, null);
            CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)Sizeof.cl_mem, null);
            CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)4L, (Pointer)Pointer.to((int[])new int[]{0}));
        }
        CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)4L, (Pointer)Pointer.to((float[])new float[]{mzWindow}));
        CL.clSetKernelArg((cl_kernel)kernel, (int)a++, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)resultsMem));
        CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)kernel, (int)1, null, (long[])new long[]{targetsLength}, null, (int)0, null, null);
    }

    private static int[] lowerBoundWithCPU(float[] array, float[] targets) {
        int[] results = new int[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            results[i] = XIC.lowerBound(array, Float.valueOf(targets[i]));
        }
        return results;
    }

    public static void initialize(int countInBatch) {
        boolean platformIndex = false;
        long deviceType = -1L;
        int deviceIndex = 2;
        CL.setExceptionsEnabled((boolean)true);
        int[] numPlatformsArray = new int[1];
        CL.clGetPlatformIDs((int)0, null, (int[])numPlatformsArray);
        int numPlatforms = numPlatformsArray[0];
        cl_platform_id[] platforms = new cl_platform_id[numPlatforms];
        CL.clGetPlatformIDs((int)platforms.length, (cl_platform_id[])platforms, null);
        cl_platform_id platform = platforms[0];
        cl_context_properties contextProperties = new cl_context_properties();
        contextProperties.addProperty(4228L, platform);
        int[] numDevicesArray = new int[1];
        CL.clGetDeviceIDs((cl_platform_id)platform, (long)-1L, (int)0, null, (int[])numDevicesArray);
        int numDevices = numDevicesArray[0];
        cl_device_id[] devices = new cl_device_id[numDevices];
        CL.clGetDeviceIDs((cl_platform_id)platform, (long)-1L, (int)numDevices, (cl_device_id[])devices, null);
        cl_device_id device = devices[2];
        context = CL.clCreateContext((cl_context_properties)contextProperties, (int)1, (cl_device_id[])new cl_device_id[]{device}, null, null, null);
        cl_queue_properties properties = new cl_queue_properties();
        commandQueue = CL.clCreateCommandQueue((cl_context)context, (cl_device_id)device, (long)0L, null);
        String programSource = XIC.readFile("src/main/resources/clkernel/XICKernel" + countInBatch + ".cpp");
        program = CL.clCreateProgramWithSource((cl_context)context, (int)1, (String[])new String[]{programSource}, null, null);
        CL.clBuildProgram((cl_program)program, (int)0, null, null, null, null);
        kernel = CL.clCreateKernel((cl_program)program, (String)"lowerBound", null);
    }

    public static void shutdown() {
        CL.clReleaseKernel((cl_kernel)kernel);
        CL.clReleaseProgram((cl_program)program);
        CL.clReleaseCommandQueue((cl_command_queue)commandQueue);
        CL.clReleaseContext((cl_context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String fileName) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fileName));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static int lowerBound(float[] array, Float target) {
        int rightIndex = array.length - 1;
        if (target.floatValue() <= array[0]) {
            return 0;
        }
        if (target.floatValue() >= array[rightIndex]) {
            return -1;
        }
        int leftIndex = 0;
        while (leftIndex + 1 < rightIndex) {
            int tmp = leftIndex + rightIndex >>> 1;
            if (target.floatValue() < array[tmp]) {
                rightIndex = tmp;
                continue;
            }
            if (target.floatValue() > array[tmp]) {
                leftIndex = tmp;
                continue;
            }
            return tmp;
        }
        return rightIndex;
    }

    public static class Spectrum {
        cl_mem mzArrayMem;
        cl_mem intArrayMem;
        int length;

        public Spectrum() {
        }

        public Spectrum(cl_mem mzArrayMem, cl_mem intArrayMem, int length) {
            this.mzArrayMem = mzArrayMem;
            this.intArrayMem = intArrayMem;
            this.length = length;
        }

        public cl_mem getMzArrayMem() {
            return this.mzArrayMem;
        }

        public cl_mem getIntArrayMem() {
            return this.intArrayMem;
        }

        public int getLength() {
            return this.length;
        }

        public void setMzArrayMem(cl_mem mzArrayMem) {
            this.mzArrayMem = mzArrayMem;
        }

        public void setIntArrayMem(cl_mem intArrayMem) {
            this.intArrayMem = intArrayMem;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Spectrum)) {
                return false;
            }
            Spectrum other = (Spectrum)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLength() != other.getLength()) {
                return false;
            }
            cl_mem this$mzArrayMem = this.getMzArrayMem();
            cl_mem other$mzArrayMem = other.getMzArrayMem();
            if (this$mzArrayMem == null ? other$mzArrayMem != null : !this$mzArrayMem.equals(other$mzArrayMem)) {
                return false;
            }
            cl_mem this$intArrayMem = this.getIntArrayMem();
            cl_mem other$intArrayMem = other.getIntArrayMem();
            return !(this$intArrayMem == null ? other$intArrayMem != null : !this$intArrayMem.equals(other$intArrayMem));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Spectrum;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            cl_mem $mzArrayMem = this.getMzArrayMem();
            result = result * 59 + ($mzArrayMem == null ? 43 : $mzArrayMem.hashCode());
            cl_mem $intArrayMem = this.getIntArrayMem();
            result = result * 59 + ($intArrayMem == null ? 43 : $intArrayMem.hashCode());
            return result;
        }

        public String toString() {
            return "XIC.Spectrum(mzArrayMem=" + this.getMzArrayMem() + ", intArrayMem=" + this.getIntArrayMem() + ", length=" + this.getLength() + ")";
        }
    }
}

