/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.TreeMap;
import net.csibio.aird.bean.AirdInfo;
import net.csibio.aird.bean.BlockIndex;
import net.csibio.aird.bean.Compressor;
import net.csibio.aird.bean.MzIntensityPairs;
import net.csibio.aird.bean.common.Spectrum;
import net.csibio.aird.bean.common.SpectrumF;
import net.csibio.aird.compressor.ByteCompressor;
import net.csibio.aird.compressor.CompressorType;
import net.csibio.aird.compressor.bytes.Zlib;
import net.csibio.aird.compressor.ints.FastPFor;
import net.csibio.aird.enums.AirdType;
import net.csibio.aird.enums.ResultCodeEnum;
import net.csibio.aird.exception.ScanException;
import net.csibio.aird.parser.CommonParser;
import net.csibio.aird.parser.DDAParser;
import net.csibio.aird.parser.PRMParser;
import net.csibio.aird.parser.v2.DIAParser;
import net.csibio.aird.util.AirdScanUtil;
import net.csibio.aird.util.FileUtil;
import org.apache.commons.lang3.ArrayUtils;

public abstract class BaseParser {
    public File airdFile;
    public File indexFile;
    public AirdInfo airdInfo;
    public Compressor mzCompressor;
    public Compressor intCompressor;
    public int mzPrecision;
    public String type;
    public RandomAccessFile raf;

    public BaseParser() {
    }

    public BaseParser(String indexPath) throws ScanException {
        this.indexFile = new File(indexPath);
        this.airdFile = new File(AirdScanUtil.getAirdPathByIndexPath(indexPath));
        try {
            this.raf = new RandomAccessFile(this.airdFile, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ScanException(ResultCodeEnum.AIRD_FILE_PARSE_ERROR);
        }
        this.airdInfo = AirdScanUtil.loadAirdInfo(this.indexFile);
        if (this.airdInfo == null) {
            throw new ScanException(ResultCodeEnum.AIRD_INDEX_FILE_PARSE_ERROR);
        }
        this.mzCompressor = BaseParser.getMzCompressor(this.airdInfo.getCompressors());
        this.intCompressor = BaseParser.getIntCompressor(this.airdInfo.getCompressors());
        this.mzPrecision = this.mzCompressor.getPrecision();
        this.type = this.airdInfo.getType();
    }

    public BaseParser(String indexPath, AirdInfo airdInfo) throws ScanException {
        if (airdInfo == null) {
            throw new ScanException(ResultCodeEnum.AIRD_INDEX_FILE_PARSE_ERROR);
        }
        this.indexFile = new File(indexPath);
        this.airdFile = new File(AirdScanUtil.getAirdPathByIndexPath(indexPath));
        try {
            this.raf = new RandomAccessFile(this.airdFile, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ScanException(ResultCodeEnum.AIRD_FILE_PARSE_ERROR);
        }
        this.airdInfo = airdInfo;
        this.mzCompressor = BaseParser.getMzCompressor(airdInfo.getCompressors());
        this.intCompressor = BaseParser.getIntCompressor(airdInfo.getCompressors());
        this.mzPrecision = this.mzCompressor.getPrecision();
        this.type = airdInfo.getType();
    }

    public static BaseParser buildParser(String indexPath) throws ScanException {
        File indexFile = new File(indexPath);
        if (indexFile.exists() && indexFile.canRead()) {
            AirdInfo airdInfo = AirdScanUtil.loadAirdInfo(indexFile);
            if (airdInfo == null) {
                throw new ScanException(ResultCodeEnum.AIRD_INDEX_FILE_PARSE_ERROR);
            }
            return switch (AirdType.getType(airdInfo.getType())) {
                case AirdType.DDA -> new DDAParser(indexPath, airdInfo);
                case AirdType.DIA_SWATH -> new DIAParser(indexPath, airdInfo);
                case AirdType.PRM -> new PRMParser(indexPath, airdInfo);
                case AirdType.COMMON -> new CommonParser(indexPath, airdInfo);
                default -> throw new IllegalStateException("Unexpected value: " + AirdType.getType(airdInfo.getType()));
            };
        }
        throw new ScanException(ResultCodeEnum.AIRD_INDEX_FILE_PARSE_ERROR);
    }

    public BaseParser(String airdPath, Compressor mzCompressor, Compressor intCompressor, int mzPrecision, String airdType) throws ScanException {
        this.indexFile = new File(AirdScanUtil.getIndexPathByAirdPath(airdPath));
        this.airdFile = new File(airdPath);
        try {
            this.raf = new RandomAccessFile(this.airdFile, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ScanException(ResultCodeEnum.AIRD_FILE_PARSE_ERROR);
        }
        this.mzCompressor = mzCompressor;
        this.intCompressor = intCompressor;
        this.mzPrecision = mzPrecision;
        this.type = airdType;
    }

    public AirdInfo getAirdInfo() {
        return this.airdInfo;
    }

    public TreeMap<Double, MzIntensityPairs> parseBlockValue(RandomAccessFile raf, BlockIndex blockIndex) throws Exception {
        TreeMap<Double, MzIntensityPairs> map = new TreeMap<Double, MzIntensityPairs>();
        List<Float> rts = blockIndex.getRts();
        raf.seek(blockIndex.getStartPtr());
        long delta = blockIndex.getEndPtr() - blockIndex.getStartPtr();
        byte[] result = new byte[(int)delta];
        raf.read(result);
        List<Long> mzSizes = blockIndex.getMzs();
        List<Long> intensitySizes = blockIndex.getInts();
        int start = 0;
        for (int i = 0; i < mzSizes.size(); ++i) {
            byte[] mz = ArrayUtils.subarray((byte[])result, (int)start, (int)(start + mzSizes.get(i).intValue()));
            byte[] intensity = ArrayUtils.subarray((byte[])result, (int)(start += mzSizes.get(i).intValue()), (int)(start + intensitySizes.get(i).intValue()));
            start += intensitySizes.get(i).intValue();
            MzIntensityPairs pairs = new MzIntensityPairs(this.getMzValues(mz), this.getIntValues(intensity));
            map.put((double)rts.get(i).floatValue() / 60.0, pairs);
            continue;
        }
        return map;
    }

    public TreeMap<Float, Spectrum> parseBlock(RandomAccessFile raf, BlockIndex blockIndex) throws Exception {
        TreeMap<Float, Spectrum> map = new TreeMap<Float, Spectrum>();
        List<Float> rts = blockIndex.getRts();
        raf.seek(blockIndex.getStartPtr());
        long delta = blockIndex.getEndPtr() - blockIndex.getStartPtr();
        byte[] result = new byte[(int)delta];
        raf.read(result);
        List<Long> mzSizes = blockIndex.getMzs();
        List<Long> intensitySizes = blockIndex.getInts();
        int start = 0;
        for (int i = 0; i < mzSizes.size(); ++i) {
            byte[] mz = ArrayUtils.subarray((byte[])result, (int)start, (int)(start + mzSizes.get(i).intValue()));
            byte[] intensity = ArrayUtils.subarray((byte[])result, (int)(start += mzSizes.get(i).intValue()), (int)(start + intensitySizes.get(i).intValue()));
            start += intensitySizes.get(i).intValue();
            Spectrum pairs = new Spectrum(this.getMzValues(mz), this.getIntValues(intensity));
            map.put(Float.valueOf(rts.get(i).floatValue() / 60.0f), pairs);
            continue;
        }
        return map;
    }

    public TreeMap<Float, SpectrumF> parseBlockAsFloat(RandomAccessFile raf, BlockIndex blockIndex) throws Exception {
        TreeMap<Float, SpectrumF> map = new TreeMap<Float, SpectrumF>();
        List<Float> rts = blockIndex.getRts();
        raf.seek(blockIndex.getStartPtr());
        long delta = blockIndex.getEndPtr() - blockIndex.getStartPtr();
        byte[] result = new byte[(int)delta];
        raf.read(result);
        List<Long> mzSizes = blockIndex.getMzs();
        List<Long> intensitySizes = blockIndex.getInts();
        int start = 0;
        for (int i = 0; i < mzSizes.size(); ++i) {
            byte[] mz = ArrayUtils.subarray((byte[])result, (int)start, (int)(start + mzSizes.get(i).intValue()));
            byte[] intensity = ArrayUtils.subarray((byte[])result, (int)(start += mzSizes.get(i).intValue()), (int)(start + intensitySizes.get(i).intValue()));
            start += intensitySizes.get(i).intValue();
            SpectrumF pairs = new SpectrumF(this.getMzValuesAsFloat(mz), this.getIntValues(intensity));
            map.put(Float.valueOf(rts.get(i).floatValue() / 60.0f), pairs);
            continue;
        }
        return map;
    }

    public double[] getMzValues(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value));
        byteBuffer.order(this.mzCompressor.fetchByteOrder());
        IntBuffer ints = byteBuffer.asIntBuffer();
        int[] intValues = new int[ints.capacity()];
        for (int i = 0; i < ints.capacity(); ++i) {
            intValues[i] = ints.get(i);
        }
        intValues = FastPFor.decode(intValues);
        double[] doubleValues = new double[intValues.length];
        for (int index = 0; index < intValues.length; ++index) {
            doubleValues[index] = intValues[index] / this.mzPrecision;
        }
        byteBuffer.clear();
        return doubleValues;
    }

    public float[] getMzValuesAsFloat(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value));
        byteBuffer.order(this.mzCompressor.fetchByteOrder());
        IntBuffer ints = byteBuffer.asIntBuffer();
        int[] intValues = new int[ints.capacity()];
        for (int i = 0; i < ints.capacity(); ++i) {
            intValues[i] = ints.get(i);
        }
        intValues = FastPFor.decode(intValues);
        float[] floats = new float[intValues.length];
        for (int index = 0; index < intValues.length; ++index) {
            floats[index] = intValues[index] / this.mzPrecision;
        }
        byteBuffer.clear();
        return floats;
    }

    public double[] getMzValues(byte[] value, int start, int length) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(Zlib.decode(value, start, length));
        byteBuffer.order(this.mzCompressor.fetchByteOrder());
        IntBuffer ints = byteBuffer.asIntBuffer();
        int[] intValues = new int[ints.capacity()];
        for (int i = 0; i < ints.capacity(); ++i) {
            intValues[i] = ints.get(i);
        }
        intValues = FastPFor.decode(intValues);
        double[] doubleValues = new double[intValues.length];
        for (int index = 0; index < intValues.length; ++index) {
            doubleValues[index] = (float)intValues[index] / (float)this.mzPrecision;
        }
        byteBuffer.clear();
        return doubleValues;
    }

    public float[] getMzValuesAsFloat(byte[] value, int start, int length) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value, start, length));
        byteBuffer.order(this.mzCompressor.fetchByteOrder());
        IntBuffer ints = byteBuffer.asIntBuffer();
        int[] intValues = new int[ints.capacity()];
        for (int i = 0; i < ints.capacity(); ++i) {
            intValues[i] = ints.get(i);
        }
        intValues = FastPFor.decode(intValues);
        float[] floats = new float[intValues.length];
        for (int index = 0; index < intValues.length; ++index) {
            floats[index] = intValues[index] / this.mzPrecision;
        }
        byteBuffer.clear();
        return floats;
    }

    public int[] getMzValuesAsInteger(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value));
        byteBuffer.order(this.mzCompressor.fetchByteOrder());
        IntBuffer ints = byteBuffer.asIntBuffer();
        int[] intValues = new int[ints.capacity()];
        for (int i = 0; i < ints.capacity(); ++i) {
            intValues[i] = ints.get(i);
        }
        intValues = FastPFor.decode(intValues);
        byteBuffer.clear();
        return intValues;
    }

    public int[] getTags(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value));
        byteBuffer.order(this.mzCompressor.fetchByteOrder());
        byte[] byteValue = new byte[byteBuffer.capacity() * 8];
        for (int i = 0; i < byteBuffer.capacity(); ++i) {
            for (int j = 0; j < 8; ++j) {
                byteValue[8 * i + j] = (byte)((byteBuffer.get(i) & 0xFF) >> j & 1);
            }
        }
        int digit = this.mzCompressor.getDigit();
        int[] tags = new int[byteValue.length / digit];
        for (int i = 0; i < tags.length; ++i) {
            for (int j = 0; j < digit; ++j) {
                int n = i;
                tags[n] = tags[n] + (byteValue[digit * i + j] << j);
            }
        }
        byteBuffer.clear();
        return tags;
    }

    public int[] getTags(byte[] value, int start, int length) {
        byte[] tagShift = new ByteCompressor(CompressorType.Zlib).decode(value, start, length);
        byte[] byteValue = new byte[tagShift.length * 8];
        for (int i = 0; i < tagShift.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                byteValue[8 * i + j] = (byte)((tagShift[i] & 0xFF) >> j & 1);
            }
        }
        int digit = this.mzCompressor.getDigit();
        int[] tags = new int[byteValue.length / digit];
        for (int i = 0; i < tags.length; ++i) {
            for (int j = 0; j < digit; ++j) {
                int n = i;
                tags[n] = tags[n] + (byteValue[digit * i + j] << j);
            }
        }
        return tags;
    }

    public float[] getIntValues(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value));
        byteBuffer.order(this.intCompressor.fetchByteOrder());
        FloatBuffer intensities = byteBuffer.asFloatBuffer();
        float[] intensityValues = new float[intensities.capacity()];
        for (int i = 0; i < intensities.capacity(); ++i) {
            intensityValues[i] = intensities.get(i);
        }
        byteBuffer.clear();
        return intensityValues;
    }

    public float[] getIntValues(byte[] value, int start, int length) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(Zlib.decode(value, start, length));
        byteBuffer.order(this.intCompressor.fetchByteOrder());
        FloatBuffer intensities = byteBuffer.asFloatBuffer();
        float[] intensityValues = new float[intensities.capacity()];
        for (int i = 0; i < intensities.capacity(); ++i) {
            intensityValues[i] = intensities.get(i);
        }
        byteBuffer.clear();
        return intensityValues;
    }

    public float[] getLogedIntValues(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value));
        byteBuffer.order(this.intCompressor.fetchByteOrder());
        FloatBuffer intensities = byteBuffer.asFloatBuffer();
        float[] intValues = new float[intensities.capacity()];
        for (int i = 0; i < intensities.capacity(); ++i) {
            intValues[i] = (float)Math.pow(10.0, intensities.get(i));
        }
        byteBuffer.clear();
        return intValues;
    }

    public float[] getLogedIntValues(byte[] value, int start, int length) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new ByteCompressor(CompressorType.Zlib).decode(value, start, length));
        byteBuffer.order(this.intCompressor.fetchByteOrder());
        FloatBuffer intensities = byteBuffer.asFloatBuffer();
        float[] intValues = new float[intensities.capacity()];
        for (int i = 0; i < intensities.capacity(); ++i) {
            intValues[i] = (float)Math.pow(10.0, intensities.get(i));
        }
        byteBuffer.clear();
        return intValues;
    }

    public void close() {
        FileUtil.close(this.raf);
    }

    public static Compressor getMzCompressor(List<Compressor> compressors) {
        if (compressors == null) {
            return null;
        }
        for (Compressor compressor : compressors) {
            if (!compressor.getTarget().equals(Compressor.TARGET_MZ)) continue;
            return compressor;
        }
        return null;
    }

    public static Compressor getIntCompressor(List<Compressor> compressors) {
        if (compressors == null) {
            return null;
        }
        for (Compressor compressor : compressors) {
            if (!compressor.getTarget().equals(Compressor.TARGET_INTENSITY)) continue;
            return compressor;
        }
        return null;
    }
}

