/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.parser;

import java.io.RandomAccessFile;
import java.util.List;
import net.csibio.aird.bean.AirdInfo;
import net.csibio.aird.bean.BlockIndex;
import net.csibio.aird.bean.Compressor;
import net.csibio.aird.bean.MzIntensityPairs;
import net.csibio.aird.exception.ScanException;
import net.csibio.aird.parser.BaseParser;
import net.csibio.aird.util.FileUtil;

public class CommonParser
extends BaseParser {
    public CommonParser(String indexFilePath) throws ScanException {
        super(indexFilePath);
    }

    public CommonParser(String indexFilePath, AirdInfo airdInfo) throws ScanException {
        super(indexFilePath, airdInfo);
    }

    public MzIntensityPairs getSpectrum(int index) {
        List<BlockIndex> indexList = this.getAirdInfo().getIndexList();
        for (int i = 0; i < indexList.size(); ++i) {
            BlockIndex blockIndex = indexList.get(i);
            if (!blockIndex.getNums().contains(index)) continue;
            int targetIndex = blockIndex.getNums().indexOf(index);
            return this.getSpectrum(blockIndex, targetIndex);
        }
        return null;
    }

    public MzIntensityPairs getSpectrum(BlockIndex index, int position) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.airdFile, "r");
            Long start = index.getMzs().get(position);
            raf.seek(start);
            Long delta = index.getInts().get(position) - start;
            byte[] reader = new byte[delta.intValue()];
            raf.read(reader);
            double[] mzArray = this.getMzValues(reader);
            start = index.getInts().get(position);
            raf.seek(start);
            delta = position == index.getInts().size() - 1 ? Long.valueOf(index.getEndPtr() - start) : Long.valueOf(index.getMzs().get(position + 1) - start);
            reader = new byte[delta.intValue()];
            raf.read(reader);
            float[] intensityArray = null;
            intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(reader) : this.getIntValues(reader);
            return new MzIntensityPairs(mzArray, intensityArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtil.close(raf);
            return null;
        }
    }
}

