/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.parser;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.csibio.aird.bean.AirdInfo;
import net.csibio.aird.bean.BlockIndex;
import net.csibio.aird.bean.DDAMs;
import net.csibio.aird.bean.MsCycle;
import net.csibio.aird.bean.MzIntensityPairs;
import net.csibio.aird.bean.common.Spectrum;
import net.csibio.aird.exception.ScanException;
import net.csibio.aird.parser.BaseParser;
import net.csibio.aird.util.DDAUtil;
import net.csibio.aird.util.FileUtil;

public class DDAParser
extends BaseParser {
    public DDAParser(String indexFilePath) throws ScanException {
        super(indexFilePath);
    }

    public DDAParser(String indexFilePath, AirdInfo airdInfo) throws ScanException {
        super(indexFilePath, airdInfo);
    }

    public BlockIndex getMs1Index() {
        if (this.airdInfo != null && this.airdInfo.getIndexList() != null && this.airdInfo.getIndexList().size() > 0) {
            return this.airdInfo.getIndexList().get(0);
        }
        return null;
    }

    public List<BlockIndex> getAllMs2Index() {
        if (this.airdInfo != null && this.airdInfo.getIndexList() != null && this.airdInfo.getIndexList().size() > 0) {
            return this.airdInfo.getIndexList().subList(1, this.airdInfo.getIndexList().size());
        }
        return null;
    }

    public List<DDAMs> readAllToMemory() throws Exception {
        RandomAccessFile raf = new RandomAccessFile(this.airdFile.getPath(), "r");
        ArrayList<DDAMs> ms1List = new ArrayList<DDAMs>();
        BlockIndex ms1Index = this.getMs1Index();
        List<BlockIndex> ms2IndexList = this.getAllMs2Index();
        TreeMap<Float, Spectrum> ms1Map = this.parseBlock(raf, ms1Index);
        ArrayList<Float> ms1RtList = new ArrayList<Float>(ms1Map.keySet());
        for (int i = 0; i < ms1RtList.size(); ++i) {
            DDAMs ms1 = new DDAMs((Float)ms1RtList.get(i), ms1Map.get(ms1RtList.get(i)));
            DDAUtil.initFromIndex(ms1, ms1Index, i);
            Optional<BlockIndex> ms2IndexRes = ms2IndexList.stream().filter(index -> index.getParentNum().equals(ms1.getNum())).findFirst();
            if (ms2IndexRes.isPresent()) {
                BlockIndex ms2Index = ms2IndexRes.get();
                TreeMap<Float, Spectrum> ms2Map = this.parseBlock(raf, ms2Index);
                ArrayList<Float> ms2RtList = new ArrayList<Float>(ms2Map.keySet());
                ArrayList<DDAMs> ms2List = new ArrayList<DDAMs>();
                for (int j = 0; j < ms2RtList.size(); ++j) {
                    DDAMs ms2 = new DDAMs((Float)ms2RtList.get(j), ms2Map.get(ms2RtList.get(j)));
                    DDAUtil.initFromIndex(ms2, ms2Index, j);
                    ms2List.add(ms2);
                }
                ms1.setMs2List(ms2List);
            }
            ms1List.add(ms1);
        }
        FileUtil.close(raf);
        return ms1List;
    }

    @Deprecated
    public List<MsCycle> parseToMsCycle() throws Exception {
        RandomAccessFile raf = new RandomAccessFile(this.airdFile.getPath(), "r");
        ArrayList<MsCycle> cycleList = new ArrayList<MsCycle>();
        List<BlockIndex> indexList = this.getAirdInfo().getIndexList();
        TreeMap<Double, MzIntensityPairs> ms1Map = this.parseBlockValue(raf, indexList.get(0));
        List<Integer> ms1ScanNumList = indexList.get(0).getNums();
        ArrayList<Double> rtList = new ArrayList<Double>(ms1Map.keySet());
        for (BlockIndex blockIndex : indexList) {
            List<Float> rts = blockIndex.getRts();
            for (int i = 0; i < rts.size(); ++i) {
                rts.set(i, Float.valueOf(rts.get(i).floatValue() / 60.0f));
            }
        }
        for (int i = 0; i < rtList.size(); ++i) {
            MsCycle tempMsc = new MsCycle();
            tempMsc.setRt((Double)rtList.get(i));
            tempMsc.setMs1Spectrum(ms1Map.get(rtList.get(i)));
            for (int tempBlockNum = 1; tempBlockNum < indexList.size(); ++tempBlockNum) {
                BlockIndex tempBlockIndex = indexList.get(tempBlockNum);
                if (!tempBlockIndex.getNum().equals(ms1ScanNumList.get(i))) continue;
                tempMsc.setRangeList(tempBlockIndex.getRangeList());
                tempMsc.setRts(tempBlockIndex.getRts());
                TreeMap<Double, MzIntensityPairs> ms2Map = this.parseBlockValue(raf, tempBlockIndex);
                ArrayList<MzIntensityPairs> ms2Spectrums = new ArrayList<MzIntensityPairs>(ms2Map.values());
                tempMsc.setMs2Spectrums(ms2Spectrums);
                break;
            }
            cycleList.add(tempMsc);
        }
        FileUtil.close(raf);
        return cycleList;
    }
}

