/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.parser;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import net.csibio.aird.bean.AirdInfo;
import net.csibio.aird.bean.BlockIndex;
import net.csibio.aird.bean.Compressor;
import net.csibio.aird.bean.MzIntensityPairs;
import net.csibio.aird.bean.SpectrumDetail;
import net.csibio.aird.eic.Extractor;
import net.csibio.aird.enums.AirdType;
import net.csibio.aird.exception.ScanException;
import net.csibio.aird.parser.BaseParser;

public class DIAParser
extends BaseParser {
    public DIAParser(String indexFilePath) throws ScanException {
        super(indexFilePath);
    }

    public DIAParser(String indexFilePath, AirdInfo airdInfo) throws ScanException {
        super(indexFilePath, airdInfo);
    }

    public DIAParser(String airdPath, Compressor mzCompressor, Compressor intCompressor, int mzPrecision) throws ScanException {
        super(airdPath, mzCompressor, intCompressor, mzPrecision, AirdType.DIA_SWATH.getName());
    }

    public TreeMap<Float, MzIntensityPairs> getSpectrums(BlockIndex index) {
        if (this.mzCompressor.getMethods().contains(Compressor.METHOD_STACK)) {
            return this.getSpectrums(index.getStartPtr(), index.getEndPtr(), index.getRts(), index.getMzs(), index.getTags(), index.getInts());
        }
        return this.getSpectrums(index.getStartPtr(), index.getEndPtr(), index.getRts(), index.getMzs(), index.getInts());
    }

    public TreeMap<Float, MzIntensityPairs> getSpectrums(long startPtr, long endPtr, List<Float> rtList, List<Long> mzSizeList, List<Long> intSizeList) {
        try {
            TreeMap<Float, MzIntensityPairs> map = new TreeMap<Float, MzIntensityPairs>();
            this.raf.seek(startPtr);
            long delta = endPtr - startPtr;
            byte[] result = new byte[(int)delta];
            this.raf.read(result);
            assert (rtList.size() == mzSizeList.size());
            assert (mzSizeList.size() == intSizeList.size());
            int start = 0;
            for (int i = 0; i < rtList.size(); ++i) {
                float[] intensityArray = null;
                double[] mzArray = this.getMzValues(result, start, mzSizeList.get(i).intValue());
                intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(result, start, intSizeList.get(i).intValue()) : this.getIntValues(result, start += mzSizeList.get(i).intValue(), intSizeList.get(i).intValue());
                start += intSizeList.get(i).intValue();
                map.put(rtList.get(i), new MzIntensityPairs(mzArray, intensityArray));
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TreeMap<Float, MzIntensityPairs> getSpectrums(long startPtr, long endPtr, List<Float> rtList, List<Long> mzSizeList, List<Long> tagSizeList, List<Long> intSizeList) {
        try {
            TreeMap<Float, MzIntensityPairs> map = new TreeMap<Float, MzIntensityPairs>();
            this.raf.seek(startPtr);
            long delta = endPtr - startPtr;
            byte[] result = new byte[(int)delta];
            this.raf.read(result);
            assert (tagSizeList.size() == mzSizeList.size());
            assert (mzSizeList.size() == intSizeList.size());
            int start = 0;
            int maxTag = (int)Math.pow(2.0, this.mzCompressor.getDigit().intValue());
            for (int i = 0; i < mzSizeList.size(); ++i) {
                int j;
                double[] mzArray = this.getMzValues(result, start, mzSizeList.get(i).intValue());
                int[] tagArray = this.getTags(result, start += mzSizeList.get(i).intValue(), tagSizeList.get(i).intValue());
                start += tagSizeList.get(i).intValue();
                HashMap<Integer, Integer> tagMap = new HashMap<Integer, Integer>();
                for (int tag : tagArray) {
                    tagMap.merge(tag, 1, Integer::sum);
                }
                ArrayList<double[]> mzGroup = new ArrayList<double[]>();
                int layerNum = tagMap.keySet().size();
                for (int j2 = 0; j2 < layerNum; ++j2) {
                    mzGroup.add(new double[((Integer)tagMap.get(j2)).intValue()]);
                }
                int[] p = new int[layerNum];
                for (int j3 = 0; j3 < tagArray.length; ++j3) {
                    int n = tagArray[j3];
                    int n2 = p[n];
                    p[n] = n2 + 1;
                    ((double[])mzGroup.get((int)tagArray[j3]))[n2] = mzArray[j3];
                }
                float[] intensityArray = null;
                intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(result, start, intSizeList.get(i).intValue()) : this.getIntValues(result, start, intSizeList.get(i).intValue());
                start += intSizeList.get(i).intValue();
                ArrayList<float[]> intensityGroup = new ArrayList<float[]>();
                int initFlag = 0;
                for (j = 0; j < layerNum; ++j) {
                    intensityGroup.add(Arrays.copyOfRange(intensityArray, initFlag, initFlag + (Integer)tagMap.get(j)));
                    initFlag += ((Integer)tagMap.get(j)).intValue();
                }
                for (j = 0; j < layerNum; ++j) {
                    map.put(rtList.get(i * maxTag + j), new MzIntensityPairs((double[])mzGroup.get(j), (float[])intensityGroup.get(j)));
                }
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MzIntensityPairs getSpectrumByRt(long startPtr, List<Float> rtList, List<Long> mzSizeList, List<Long> intSizeList, float rt) {
        int position = rtList.indexOf(Float.valueOf(rt));
        return this.getSpectrumByIndex(startPtr, mzSizeList, intSizeList, position);
    }

    public MzIntensityPairs getSpectrumByRt(long startPtr, List<Float> rtList, List<Long> mzSizeList, List<Long> tagSizeList, List<Long> intSizeList, float rt) {
        int position = rtList.indexOf(Float.valueOf(rt));
        return this.getSpectrumByIndex(startPtr, mzSizeList, tagSizeList, intSizeList, position);
    }

    public MzIntensityPairs getSpectrumByRt(BlockIndex index, float rt) {
        List<Float> rts = index.getRts();
        int position = rts.indexOf(Float.valueOf(rt));
        return this.getSpectrumByIndex(index, position);
    }

    public TreeMap<Float, MzIntensityPairs> getSpectrumsByRtRange(Long startPtr, List<Float> rts, List<Long> mzSizeList, List<Long> intSizeList, float rtStart, float rtEnd) {
        float[] rtArray = new float[rts.size()];
        for (int i = 0; i < rts.size(); ++i) {
            rtArray[i] = rts.get(i).floatValue();
        }
        int startIndex = Extractor.lowerBound(rtArray, Float.valueOf(rtStart));
        int endIndex = Extractor.lowerBound(rtArray, Float.valueOf(rtEnd));
        return this.getSpectrumByIndexRange(startPtr, rts, mzSizeList, intSizeList, startIndex, endIndex);
    }

    public TreeMap<Float, MzIntensityPairs> getSpectrumByIndexRange(long startPtr, List<Float> rts, List<Long> mzSizeList, List<Long> intSizeList, int indexStart, int indexEnd) {
        long start = startPtr;
        for (int i = 0; i < indexStart; ++i) {
            start += mzSizeList.get(i).longValue();
            start += intSizeList.get(i).longValue();
        }
        long end = start;
        for (int j = indexStart; j < indexEnd; ++j) {
            end += mzSizeList.get(j).longValue();
            end += intSizeList.get(j).longValue();
        }
        return this.getSpectrums(start, end, rts.subList(indexStart, indexEnd), mzSizeList.subList(indexStart, indexEnd), intSizeList.subList(indexStart, indexEnd));
    }

    public MzIntensityPairs getSpectrumByIndex(long startPtr, List<Long> mzSizeList, List<Long> intSizeList, int index) {
        try {
            this.raf = new RandomAccessFile(this.airdFile, "r");
            long start = startPtr;
            for (int i = 0; i < index; ++i) {
                start += mzSizeList.get(i).longValue();
                start += intSizeList.get(i).longValue();
            }
            this.raf.seek(start);
            byte[] reader = new byte[mzSizeList.get(index).intValue()];
            this.raf.read(reader);
            double[] mzArray = this.getMzValues(reader);
            this.raf.seek(start += (long)mzSizeList.get(index).intValue());
            reader = new byte[intSizeList.get(index).intValue()];
            this.raf.read(reader);
            float[] intensityArray = null;
            intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(reader) : this.getIntValues(reader);
            return new MzIntensityPairs(mzArray, intensityArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SpectrumDetail getSpectrumDetailByIndex(long startPtr, List<Long> mzSizeList, List<Long> intSizeList, int index) {
        SpectrumDetail detail = new SpectrumDetail();
        try {
            this.raf = new RandomAccessFile(this.airdFile, "r");
            long start = startPtr;
            for (int i = 0; i < index; ++i) {
                start += mzSizeList.get(i).longValue();
                start += intSizeList.get(i).longValue();
            }
            this.raf.seek(start);
            byte[] reader = new byte[mzSizeList.get(index).intValue()];
            this.raf.read(reader);
            detail.setMzBytes((byte[])reader.clone());
            double[] mzArray = this.getMzValues(reader);
            this.raf.seek(start += (long)mzSizeList.get(index).intValue());
            reader = new byte[intSizeList.get(index).intValue()];
            this.raf.read(reader);
            detail.setIntensityBytes((byte[])reader.clone());
            float[] intensityArray = null;
            intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(reader) : this.getIntValues(reader);
            detail.setMzs(mzArray);
            detail.setIntensities(intensityArray);
            return detail;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MzIntensityPairs getSpectrumByIndex(long startPtr, List<Long> mzSizeList, List<Long> tagSizeList, List<Long> intSizeList, int index) {
        try {
            this.raf = new RandomAccessFile(this.airdFile, "r");
            long start = startPtr;
            int maxTag = (int)Math.pow(2.0, this.mzCompressor.getDigit().intValue());
            int mzIndex = index / maxTag;
            for (int i = 0; i < mzIndex; ++i) {
                start += mzSizeList.get(i).longValue();
                start += tagSizeList.get(i).longValue();
                start += intSizeList.get(i).longValue();
            }
            this.raf.seek(start);
            byte[] reader = new byte[mzSizeList.get(mzIndex).intValue()];
            this.raf.read(reader);
            double[] mzArray = this.getMzValues(reader);
            this.raf.seek(start += (long)mzSizeList.get(mzIndex).intValue());
            reader = new byte[tagSizeList.get(mzIndex).intValue()];
            this.raf.read(reader);
            int[] tagArray = this.getTags(reader);
            this.raf.seek(start += (long)tagSizeList.get(mzIndex).intValue());
            reader = new byte[intSizeList.get(mzIndex).intValue()];
            this.raf.read(reader);
            float[] intensityArray = null;
            intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(reader) : this.getIntValues(reader);
            HashMap<Integer, Integer> tagMap = new HashMap<Integer, Integer>();
            for (int tag : tagArray) {
                tagMap.merge(tag, 1, Integer::sum);
            }
            ArrayList<double[]> mzGroup = new ArrayList<double[]>();
            int layerNum = tagMap.keySet().size();
            for (int j = 0; j < layerNum; ++j) {
                mzGroup.add(new double[((Integer)tagMap.get(j)).intValue()]);
            }
            int[] p = new int[layerNum];
            for (int j = 0; j < tagArray.length; ++j) {
                int n = tagArray[j];
                int n2 = p[n];
                p[n] = n2 + 1;
                ((double[])mzGroup.get((int)tagArray[j]))[n2] = mzArray[j];
            }
            ArrayList<float[]> intensityGroup = new ArrayList<float[]>();
            int initFlag = 0;
            for (int j = 0; j < layerNum; ++j) {
                intensityGroup.add(Arrays.copyOfRange(intensityArray, initFlag, initFlag + (Integer)tagMap.get(j)));
                initFlag += ((Integer)tagMap.get(j)).intValue();
            }
            int remainder = index - mzIndex * maxTag;
            return new MzIntensityPairs((double[])mzGroup.get(remainder), (float[])intensityGroup.get(remainder));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MzIntensityPairs getSpectrumByIndex(BlockIndex blockIndex, int index) {
        if (this.mzCompressor.getMethods().contains(Compressor.METHOD_STACK)) {
            return this.getSpectrumByIndex(blockIndex.getStartPtr(), blockIndex.getMzs(), blockIndex.getTags(), blockIndex.getInts(), index);
        }
        return this.getSpectrumByIndex(blockIndex.getStartPtr(), blockIndex.getMzs(), blockIndex.getInts(), index);
    }

    public MzIntensityPairs getSpectrum(int index) {
        List<BlockIndex> indexList = this.getAirdInfo().getIndexList();
        for (int i = 0; i < indexList.size(); ++i) {
            BlockIndex blockIndex = indexList.get(i);
            if (!blockIndex.getNums().contains(index)) continue;
            int targetIndex = blockIndex.getNums().indexOf(index);
            return this.getSpectrumByIndex(blockIndex, targetIndex);
        }
        return null;
    }

    public MzIntensityPairs getSpectrumAsInteger(BlockIndex index, float rt, int compressor) {
        if (compressor == 0) {
            return this.getSpectrumAsInteger(index, rt);
        }
        if (compressor == 1) {
            List<Float> rts = index.getRts();
            int position = rts.indexOf(Float.valueOf(rt));
            MzIntensityPairs mzIntensityPairs = this.getSpectrumByIndex(index, position);
            int[] mzArray = new int[mzIntensityPairs.getMzArray().length];
            for (int i = 0; i < mzArray.length; ++i) {
                mzArray[i] = (int)(mzIntensityPairs.getMzArray()[i] * (double)this.mzPrecision);
            }
            return new MzIntensityPairs(mzArray, mzIntensityPairs.getIntensityArray());
        }
        System.out.println("No such compressor.");
        return null;
    }

    public MzIntensityPairs getSpectrumAsInteger(BlockIndex index, float rt) {
        try {
            this.raf = new RandomAccessFile(this.airdFile, "r");
            List<Float> rts = index.getRts();
            int position = rts.indexOf(Float.valueOf(rt));
            long start = index.getStartPtr();
            for (int i = 0; i < position; ++i) {
                start += index.getMzs().get(i).longValue();
                start += index.getInts().get(i).longValue();
            }
            this.raf.seek(start);
            byte[] reader = new byte[index.getMzs().get(position).intValue()];
            this.raf.read(reader);
            int[] mzArray = this.getMzValuesAsInteger(reader);
            this.raf.seek(start += (long)index.getMzs().get(position).intValue());
            reader = new byte[index.getInts().get(position).intValue()];
            this.raf.read(reader);
            float[] intensityArray = null;
            intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(reader) : this.getIntValues(reader);
            return new MzIntensityPairs(mzArray, intensityArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

