/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.parser.v2;

import java.util.List;
import java.util.TreeMap;
import net.csibio.aird.bean.AirdInfo;
import net.csibio.aird.bean.BlockIndex;
import net.csibio.aird.bean.Compressor;
import net.csibio.aird.bean.common.Spectrum;
import net.csibio.aird.bean.common.SpectrumF;
import net.csibio.aird.enums.AirdType;
import net.csibio.aird.exception.ScanException;
import net.csibio.aird.parser.BaseParser;

public class DIAParser
extends BaseParser {
    public DIAParser(String indexFilePath) throws ScanException {
        super(indexFilePath);
    }

    public DIAParser(String indexFilePath, AirdInfo airdInfo) throws ScanException {
        super(indexFilePath, airdInfo);
    }

    public DIAParser(String airdPath, Compressor mzCompressor, Compressor intCompressor, int mzPrecision) throws ScanException {
        super(airdPath, mzCompressor, intCompressor, mzPrecision, AirdType.DIA_SWATH.getName());
    }

    public TreeMap<Float, Spectrum> getSpectrums(BlockIndex index) {
        return this.getSpectrums(index.getStartPtr(), index.getEndPtr(), index.getRts(), index.getMzs(), index.getInts());
    }

    public TreeMap<Float, SpectrumF> getSpectrumsAsFloat(BlockIndex index) {
        return this.getSpectrumsAsFloat(index.getStartPtr(), index.getEndPtr(), index.getRts(), index.getMzs(), index.getInts());
    }

    public TreeMap<Float, Spectrum> getSpectrums(long startPtr, long endPtr, List<Float> rtList, List<Long> mzSizeList, List<Long> intSizeList) {
        try {
            TreeMap<Float, Spectrum> map = new TreeMap<Float, Spectrum>();
            this.raf.seek(startPtr);
            long delta = endPtr - startPtr;
            byte[] result = new byte[(int)delta];
            this.raf.read(result);
            assert (rtList.size() == mzSizeList.size());
            assert (mzSizeList.size() == intSizeList.size());
            int start = 0;
            for (int i = 0; i < rtList.size(); ++i) {
                float[] intensityArray = null;
                double[] mzArray = this.getMzValues(result, start, mzSizeList.get(i).intValue());
                intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(result, start, intSizeList.get(i).intValue()) : this.getIntValues(result, start += mzSizeList.get(i).intValue(), intSizeList.get(i).intValue());
                start += intSizeList.get(i).intValue();
                map.put(rtList.get(i), new Spectrum(mzArray, intensityArray));
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TreeMap<Float, SpectrumF> getSpectrumsAsFloat(long startPtr, long endPtr, List<Float> rtList, List<Long> mzSizeList, List<Long> intSizeList) {
        try {
            TreeMap<Float, SpectrumF> map = new TreeMap<Float, SpectrumF>();
            this.raf.seek(startPtr);
            long delta = endPtr - startPtr;
            byte[] result = new byte[(int)delta];
            this.raf.read(result);
            assert (rtList.size() == mzSizeList.size());
            assert (mzSizeList.size() == intSizeList.size());
            int start = 0;
            for (int i = 0; i < rtList.size(); ++i) {
                float[] intensityArray = null;
                float[] mzArray = this.getMzValuesAsFloat(result, start, mzSizeList.get(i).intValue());
                intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(result, start, intSizeList.get(i).intValue()) : this.getIntValues(result, start += mzSizeList.get(i).intValue(), intSizeList.get(i).intValue());
                start += intSizeList.get(i).intValue();
                map.put(rtList.get(i), new SpectrumF(mzArray, intensityArray));
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Spectrum getSpectrumByRt(long startPtr, List<Float> rtList, List<Long> mzSizeList, List<Long> intSizeList, float rt) {
        int position = rtList.indexOf(Float.valueOf(rt));
        return this.getSpectrumByIndex(startPtr, mzSizeList, intSizeList, position);
    }

    public Spectrum getSpectrum(int index) {
        List<BlockIndex> indexList = this.getAirdInfo().getIndexList();
        for (int i = 0; i < indexList.size(); ++i) {
            BlockIndex blockIndex = indexList.get(i);
            if (!blockIndex.getNums().contains(index)) continue;
            int targetIndex = blockIndex.getNums().indexOf(index);
            return this.getSpectrumByIndex(blockIndex, targetIndex);
        }
        return null;
    }

    public Spectrum getSpectrumByRt(BlockIndex index, float rt) {
        List<Float> rts = index.getRts();
        int position = rts.indexOf(Float.valueOf(rt));
        return this.getSpectrumByIndex(index, position);
    }

    public Spectrum getSpectrumByIndex(BlockIndex blockIndex, int index) {
        return this.getSpectrumByIndex(blockIndex.getStartPtr(), blockIndex.getMzs(), blockIndex.getInts(), index);
    }

    public Spectrum getSpectrumByIndex(long startPtr, List<Long> mzSizeList, List<Long> intSizeList, int index) {
        try {
            long start = startPtr;
            for (int i = 0; i < index; ++i) {
                start += mzSizeList.get(i).longValue();
                start += intSizeList.get(i).longValue();
            }
            this.raf.seek(start);
            byte[] reader = new byte[mzSizeList.get(index).intValue()];
            this.raf.read(reader);
            double[] mzArray = this.getMzValues(reader);
            this.raf.seek(start += (long)mzSizeList.get(index).intValue());
            reader = new byte[intSizeList.get(index).intValue()];
            this.raf.read(reader);
            float[] intensityArray = null;
            intensityArray = this.intCompressor.getMethods().contains(Compressor.METHOD_LOG10) ? this.getLogedIntValues(reader) : this.getIntValues(reader);
            return new Spectrum(mzArray, intensityArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

