/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.sample;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_device_id;
import org.jocl.cl_platform_id;

public class OpenCLQuery {
    public static void main(String[] args) {
        int[] numPlatforms = new int[1];
        CL.clGetPlatformIDs((int)0, null, (int[])numPlatforms);
        System.out.println("Number of platforms: " + numPlatforms[0]);
        cl_platform_id[] platforms = new cl_platform_id[numPlatforms[0]];
        CL.clGetPlatformIDs((int)platforms.length, (cl_platform_id[])platforms, null);
        ArrayList<cl_device_id> devices = new ArrayList<cl_device_id>();
        for (int i = 0; i < platforms.length; ++i) {
            String platformName = OpenCLQuery.getString(platforms[i], 2306);
            int[] numDevices = new int[1];
            CL.clGetDeviceIDs((cl_platform_id)platforms[i], (long)-1L, (int)0, null, (int[])numDevices);
            System.out.println("Number of devices in platform " + platformName + ": " + numDevices[0]);
            String platformVersion = OpenCLQuery.getString(platforms[i], 2305);
            System.out.printf("CL_PLATFORM_VERSION: \t\t\t%s\n", platformVersion);
            cl_device_id[] devicesArray = new cl_device_id[numDevices[0]];
            CL.clGetDeviceIDs((cl_platform_id)platforms[i], (long)-1L, (int)numDevices[0], (cl_device_id[])devicesArray, null);
            devices.addAll(Arrays.asList(devicesArray));
        }
        for (cl_device_id device : devices) {
            String deviceName = OpenCLQuery.getString(device, 4139);
            System.out.println("--- Info for device " + deviceName + ": ---");
            System.out.printf("CL_DEVICE_NAME: \t\t\t%s\n", deviceName);
            String deviceVendor = OpenCLQuery.getString(device, 4140);
            System.out.printf("CL_DEVICE_VENDOR: \t\t\t%s\n", deviceVendor);
            String driverVersion = OpenCLQuery.getString(device, 4141);
            System.out.printf("CL_DRIVER_VERSION: \t\t\t%s\n", driverVersion);
            long deviceType = OpenCLQuery.getLong(device, 4096);
            if ((deviceType & 2L) != 0L) {
                System.out.printf("CL_DEVICE_TYPE:\t\t\t\t%s\n", "CL_DEVICE_TYPE_CPU");
            }
            if ((deviceType & 4L) != 0L) {
                System.out.printf("CL_DEVICE_TYPE:\t\t\t\t%s\n", "CL_DEVICE_TYPE_GPU");
            }
            if ((deviceType & 8L) != 0L) {
                System.out.printf("CL_DEVICE_TYPE:\t\t\t\t%s\n", "CL_DEVICE_TYPE_ACCELERATOR");
            }
            if ((deviceType & 1L) != 0L) {
                System.out.printf("CL_DEVICE_TYPE:\t\t\t\t%s\n", "CL_DEVICE_TYPE_DEFAULT");
            }
            int maxComputeUnits = OpenCLQuery.getInt(device, 4098);
            System.out.printf("CL_DEVICE_MAX_COMPUTE_UNITS:\t\t%d\n", maxComputeUnits);
            long maxWorkItemDimensions = OpenCLQuery.getLong(device, 4099);
            System.out.printf("CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS:\t%d\n", maxWorkItemDimensions);
            long[] maxWorkItemSizes = OpenCLQuery.getSizes(device, 4101, 3);
            System.out.printf("CL_DEVICE_MAX_WORK_ITEM_SIZES:\t\t%d / %d / %d \n", maxWorkItemSizes[0], maxWorkItemSizes[1], maxWorkItemSizes[2]);
            long maxWorkGroupSize = OpenCLQuery.getSize(device, 4100);
            System.out.printf("CL_DEVICE_MAX_WORK_GROUP_SIZE:\t\t%d\n", maxWorkGroupSize);
            long maxClockFrequency = OpenCLQuery.getLong(device, 4108);
            System.out.printf("CL_DEVICE_MAX_CLOCK_FREQUENCY:\t\t%d MHz\n", maxClockFrequency);
            int addressBits = OpenCLQuery.getInt(device, 4109);
            System.out.printf("CL_DEVICE_ADDRESS_BITS:\t\t\t%d\n", addressBits);
            long maxMemAllocSize = OpenCLQuery.getLong(device, 4112);
            System.out.printf("CL_DEVICE_MAX_MEM_ALLOC_SIZE:\t\t%d MByte\n", (int)(maxMemAllocSize / 0x100000L));
            long globalMemSize = OpenCLQuery.getLong(device, 4127);
            System.out.printf("CL_DEVICE_GLOBAL_MEM_SIZE:\t\t%d MByte\n", (int)(globalMemSize / 0x100000L));
            int errorCorrectionSupport = OpenCLQuery.getInt(device, 4132);
            System.out.printf("CL_DEVICE_ERROR_CORRECTION_SUPPORT:\t%s\n", errorCorrectionSupport != 0 ? "yes" : "no");
            int localMemType = OpenCLQuery.getInt(device, 4130);
            System.out.printf("CL_DEVICE_LOCAL_MEM_TYPE:\t\t%s\n", localMemType == 1 ? "local" : "global");
            long localMemSize = OpenCLQuery.getLong(device, 4131);
            System.out.printf("CL_DEVICE_LOCAL_MEM_SIZE:\t\t%d KByte\n", (int)(localMemSize / 1024L));
            long maxConstantBufferSize = OpenCLQuery.getLong(device, 4128);
            System.out.printf("CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE:\t%d KByte\n", (int)(maxConstantBufferSize / 1024L));
            long queueProperties = OpenCLQuery.getLong(device, 4138);
            if ((queueProperties & 1L) != 0L) {
                System.out.printf("CL_DEVICE_QUEUE_PROPERTIES:\t\t%s\n", "CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE");
            }
            if ((queueProperties & 2L) != 0L) {
                System.out.printf("CL_DEVICE_QUEUE_PROPERTIES:\t\t%s\n", "CL_QUEUE_PROFILING_ENABLE");
            }
            int imageSupport = OpenCLQuery.getInt(device, 4118);
            System.out.printf("CL_DEVICE_IMAGE_SUPPORT:\t\t%d\n", imageSupport);
            int maxReadImageArgs = OpenCLQuery.getInt(device, 4110);
            System.out.printf("CL_DEVICE_MAX_READ_IMAGE_ARGS:\t\t%d\n", maxReadImageArgs);
            int maxWriteImageArgs = OpenCLQuery.getInt(device, 4111);
            System.out.printf("CL_DEVICE_MAX_WRITE_IMAGE_ARGS:\t\t%d\n", maxWriteImageArgs);
            long singleFpConfig = OpenCLQuery.getLong(device, 4123);
            System.out.printf("CL_DEVICE_SINGLE_FP_CONFIG:\t\t%s\n", CL.stringFor_cl_device_fp_config((long)singleFpConfig));
            long image2dMaxWidth = OpenCLQuery.getSize(device, 4113);
            System.out.printf("CL_DEVICE_2D_MAX_WIDTH\t\t\t%d\n", image2dMaxWidth);
            long image2dMaxHeight = OpenCLQuery.getSize(device, 4114);
            System.out.printf("CL_DEVICE_2D_MAX_HEIGHT\t\t\t%d\n", image2dMaxHeight);
            long image3dMaxWidth = OpenCLQuery.getSize(device, 4115);
            System.out.printf("CL_DEVICE_3D_MAX_WIDTH\t\t\t%d\n", image3dMaxWidth);
            long image3dMaxHeight = OpenCLQuery.getSize(device, 4116);
            System.out.printf("CL_DEVICE_3D_MAX_HEIGHT\t\t\t%d\n", image3dMaxHeight);
            long image3dMaxDepth = OpenCLQuery.getSize(device, 4117);
            System.out.printf("CL_DEVICE_3D_MAX_DEPTH\t\t\t%d\n", image3dMaxDepth);
            System.out.printf("CL_DEVICE_PREFERRED_VECTOR_WIDTH_<t>\t", new Object[0]);
            int preferredVectorWidthChar = OpenCLQuery.getInt(device, 4102);
            int preferredVectorWidthShort = OpenCLQuery.getInt(device, 4103);
            int preferredVectorWidthInt = OpenCLQuery.getInt(device, 4104);
            int preferredVectorWidthLong = OpenCLQuery.getInt(device, 4105);
            int preferredVectorWidthFloat = OpenCLQuery.getInt(device, 4106);
            int preferredVectorWidthDouble = OpenCLQuery.getInt(device, 4107);
            System.out.printf("CHAR %d, SHORT %d, INT %d, LONG %d, FLOAT %d, DOUBLE %d\n\n\n", preferredVectorWidthChar, preferredVectorWidthShort, preferredVectorWidthInt, preferredVectorWidthLong, preferredVectorWidthFloat, preferredVectorWidthDouble);
        }
    }

    private static int getInt(cl_device_id device, int paramName) {
        return OpenCLQuery.getInts(device, paramName, 1)[0];
    }

    private static int[] getInts(cl_device_id device, int paramName, int numValues) {
        int[] values = new int[numValues];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)(4 * numValues), (Pointer)Pointer.to((int[])values), null);
        return values;
    }

    private static long getLong(cl_device_id device, int paramName) {
        return OpenCLQuery.getLongs(device, paramName, 1)[0];
    }

    private static long[] getLongs(cl_device_id device, int paramName, int numValues) {
        long[] values = new long[numValues];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)(8 * numValues), (Pointer)Pointer.to((long[])values), null);
        return values;
    }

    private static String getString(cl_device_id device, int paramName) {
        long[] size = new long[1];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)0L, null, (long[])size);
        byte[] buffer = new byte[(int)size[0]];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)buffer.length, (Pointer)Pointer.to((byte[])buffer), null);
        return new String(buffer, 0, buffer.length - 1);
    }

    private static String getString(cl_platform_id platform, int paramName) {
        long[] size = new long[1];
        CL.clGetPlatformInfo((cl_platform_id)platform, (int)paramName, (long)0L, null, (long[])size);
        byte[] buffer = new byte[(int)size[0]];
        CL.clGetPlatformInfo((cl_platform_id)platform, (int)paramName, (long)buffer.length, (Pointer)Pointer.to((byte[])buffer), null);
        return new String(buffer, 0, buffer.length - 1);
    }

    private static long getSize(cl_device_id device, int paramName) {
        return OpenCLQuery.getSizes(device, paramName, 1)[0];
    }

    static long[] getSizes(cl_device_id device, int paramName, int numValues) {
        ByteBuffer buffer = ByteBuffer.allocate(numValues * Sizeof.size_t).order(ByteOrder.nativeOrder());
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)(Sizeof.size_t * numValues), (Pointer)Pointer.to((Buffer)buffer), null);
        long[] values = new long[numValues];
        if (Sizeof.size_t == 4) {
            for (int i = 0; i < numValues; ++i) {
                values[i] = buffer.getInt(i * Sizeof.size_t);
            }
        } else {
            for (int i = 0; i < numValues; ++i) {
                values[i] = buffer.getLong(i * Sizeof.size_t);
            }
        }
        return values;
    }
}

