/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.util;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.csibio.aird.bean.AirdInfo;
import net.csibio.aird.enums.ResultCodeEnum;
import net.csibio.aird.exception.ScanException;
import net.csibio.aird.util.FileUtil;

public class AirdScanUtil {
    public static List<File> scanIndexFiles(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.isDirectory()) {
            throw new ScanException(ResultCodeEnum.NOT_DIRECTORY);
        }
        if (!directory.exists()) {
            throw new ScanException(ResultCodeEnum.DIRECTORY_NOT_EXISTS);
        }
        ArrayList<File> indexFileList = new ArrayList<File>();
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            return null;
        }
        for (File file : fileList) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".json")) continue;
            indexFileList.add(file);
        }
        return indexFileList;
    }

    public static AirdInfo loadAirdInfo(File indexFile) {
        String content = FileUtil.readFile(indexFile);
        AirdInfo airdInfo = null;
        try {
            long start = System.currentTimeMillis();
            airdInfo = (AirdInfo)JSONObject.parseObject((String)content, AirdInfo.class);
            System.out.println("JSON loading time:" + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Exception e) {
            System.out.println(indexFile.getAbsolutePath());
            System.out.println(ResultCodeEnum.NOT_AIRD_INDEX_FILE.getMessage());
            e.printStackTrace();
            return null;
        }
        return airdInfo;
    }

    public static List<AirdInfo> loadAirdInfoList(List<File> indexFiles) {
        ArrayList<AirdInfo> airdInfos = new ArrayList<AirdInfo>();
        for (File file : indexFiles) {
            AirdInfo airdInfo = AirdScanUtil.loadAirdInfo(file);
            if (airdInfo != null) {
                airdInfos.add(airdInfo);
                continue;
            }
            System.out.println(file.getAbsolutePath());
            System.out.println(ResultCodeEnum.AIRD_INDEX_FILE_PARSE_ERROR);
        }
        return airdInfos;
    }

    public static HashMap<String, AirdInfo> loadAirdInfoMap(List<File> indexFiles) {
        HashMap<String, AirdInfo> airdInfoMap = new HashMap<String, AirdInfo>();
        for (File file : indexFiles) {
            AirdInfo airdInfo = AirdScanUtil.loadAirdInfo(file);
            if (airdInfo != null) {
                airdInfoMap.put(file.getAbsolutePath(), airdInfo);
                continue;
            }
            System.out.println(file.getAbsolutePath());
            System.out.println(ResultCodeEnum.AIRD_INDEX_FILE_PARSE_ERROR);
        }
        return airdInfoMap;
    }

    public static String getIndexPathByAirdPath(String airdPath) {
        if (airdPath == null || airdPath.isEmpty() || !airdPath.contains(".") || !airdPath.endsWith(".aird")) {
            return null;
        }
        return airdPath.substring(0, airdPath.lastIndexOf(".")) + ".json";
    }

    public static String getAirdPathByIndexPath(String indexPath) {
        if (indexPath == null || indexPath.isEmpty() || !indexPath.contains(".") || !indexPath.endsWith(".json")) {
            return null;
        }
        return indexPath.substring(0, indexPath.lastIndexOf(".")) + ".aird";
    }

    public static boolean isAirdFile(String airdPath) {
        if (airdPath == null || airdPath.isEmpty() || !airdPath.contains(".") || !airdPath.endsWith(".aird")) {
            return false;
        }
        return airdPath.toLowerCase().endsWith(".aird");
    }

    public static boolean isIndexFile(String indexPath) {
        if (indexPath == null || indexPath.isEmpty() || !indexPath.contains(".") || !indexPath.endsWith(".json")) {
            return false;
        }
        return indexPath.toLowerCase().endsWith(".json");
    }
}

