/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.util;

import java.util.Iterator;
import java.util.Set;
import net.csibio.aird.bean.common.Spectrum;
import net.csibio.aird.bean.common.SpectrumF;
import net.csibio.aird.structure.SortInt;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.Pair;

public class ArrayUtil {
    public static SortInt[] transToSortIntArray(int[] originalArray, int currentLayer) {
        SortInt[] sortInts = new SortInt[originalArray.length];
        for (int i = 0; i < originalArray.length; ++i) {
            sortInts[i] = new SortInt(originalArray[i], currentLayer);
        }
        return sortInts;
    }

    public static SpectrumF trans(Spectrum spectrum) {
        float[] floats = new float[spectrum.mzs().length];
        for (int i = 0; i < spectrum.mzs().length; ++i) {
            floats[i] = (float)spectrum.mzs()[i];
        }
        return new SpectrumF(floats, spectrum.ints());
    }

    public static double[] fromFloatToDouble(float[] array) {
        if (array == null) {
            return null;
        }
        double[] newArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Pair<int[], byte[]> transToOriginArrayAndLayerNote(SortInt[] sortInts, int totalLayersCount) {
        int[] mz = new int[sortInts.length];
        Integer layerNote = 0;
        byte[] layerNoteBytes = new byte[(int)Math.ceil((double)sortInts.length / 8.0 * (double)totalLayersCount)];
        int count = 0;
        int addWhenMatch = 8;
        int currentByteLocation = 0;
        for (int i = 0; i < sortInts.length; ++i) {
            mz[i] = sortInts[i].getNumber();
            layerNote = layerNote << totalLayersCount;
            layerNote = layerNote | sortInts[i].getLayer();
            if ((count += totalLayersCount) < addWhenMatch) continue;
            if (count == addWhenMatch) {
                layerNoteBytes[currentByteLocation] = layerNote.byteValue();
            } else {
                layerNoteBytes[currentByteLocation] = Integer.valueOf(layerNote >> count - addWhenMatch).byteValue();
                layerNote = layerNote << 32 - (count - addWhenMatch) >>> 32 - (count - addWhenMatch);
            }
            ++currentByteLocation;
            count -= addWhenMatch;
        }
        if (count != 0) {
            layerNoteBytes[currentByteLocation] = layerNote.byteValue();
        }
        return new Pair((Object)mz, (Object)ArrayUtils.subarray((byte[])layerNoteBytes, (int)0, (int)(currentByteLocation + 1)));
    }

    public static long avgDelta(int[] array) {
        long delta = 0L;
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i + 1] - array[i] != 0) continue;
            ++delta;
        }
        return delta;
    }

    public static float[] toPrimitive(Set<Float> floatSet) {
        if (floatSet.size() == 0) {
            return null;
        }
        float[] fArray = new float[floatSet.size()];
        int i = 0;
        Iterator<Float> iterator = floatSet.iterator();
        while (iterator.hasNext()) {
            fArray[i] = iterator.next().floatValue();
            ++i;
        }
        return fArray;
    }

    public static boolean isSame(float[] a, float[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSame(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

