/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.differential.IntegratedBinaryPacking;
import me.lemire.integercompression.differential.IntegratedVariableByte;
import me.lemire.integercompression.differential.SkippableIntegratedComposition;
import me.lemire.integercompression.differential.SkippableIntegratedIntegerCODEC;
import net.csibio.aird.bean.Compressor;
import net.csibio.aird.util.FileUtil;
import org.apache.commons.codec.binary.Base64;

@Deprecated
public class CompressUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlibEncoder(byte[] data) {
        byte[] output;
        Deflater compressor = new Deflater();
        compressor.reset();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        try {
            byte[] buf = new byte[1024];
            while (!compressor.finished()) {
                int i = compressor.deflate(buf);
                bos.write(buf, 0, i);
            }
            output = bos.toByteArray();
        }
        catch (Exception e) {
            output = data;
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        compressor.end();
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlibDecoder(byte[] data) {
        byte[] output;
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        try {
            byte[] buffer = new byte[10240];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            output = outputStream.toByteArray();
        }
        catch (Exception e) {
            output = data;
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlibDecoder(byte[] data, int start, int length) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(data, start, length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        try {
            byte[] buff = new byte[1024];
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buff);
                baos.write(buff, 0, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.close(baos);
        }
        decompressor.end();
        byte[] output = baos.toByteArray();
        return output;
    }

    public static byte[] ZDPDEncoder(float[] sortedFloats, Compressor compressor) {
        int precision = compressor.getPrecision();
        int[] sortedInts = new int[sortedFloats.length];
        for (int i = 0; i < sortedFloats.length; ++i) {
            sortedInts[i] = (int)((float)precision * sortedFloats[i]);
        }
        int[] compressedInts = CompressUtil.fastPforEncoder(sortedInts);
        return CompressUtil.transToByte(compressedInts);
    }

    public static byte[] ZDPDEncoder(int[] sortedInts) {
        int[] compressedInts = CompressUtil.fastPforEncoder(sortedInts);
        return CompressUtil.transToByte(compressedInts);
    }

    public static int[] ZDPDDecoder(byte[] compressedBytes) {
        int[] compressedInts = CompressUtil.transToInteger(compressedBytes);
        return CompressUtil.fastPforDecoder(compressedInts);
    }

    public static int[] fastPforDecoder(int[] compressedInts) {
        SkippableIntegratedComposition codec = new SkippableIntegratedComposition((SkippableIntegratedIntegerCODEC)new IntegratedBinaryPacking(), (SkippableIntegratedIntegerCODEC)new IntegratedVariableByte());
        int size = compressedInts[0];
        int[] recovered = new int[size];
        IntWrapper inPoso = new IntWrapper(1);
        IntWrapper outPoso = new IntWrapper(0);
        IntWrapper recoffset = new IntWrapper(0);
        codec.headlessUncompress(compressedInts, inPoso, compressedInts.length, recovered, recoffset, size, outPoso);
        return recovered;
    }

    public static int[] fastPforEncoder(int[] sortedInt) {
        SkippableIntegratedComposition codec = new SkippableIntegratedComposition((SkippableIntegratedIntegerCODEC)new IntegratedBinaryPacking(), (SkippableIntegratedIntegerCODEC)new IntegratedVariableByte());
        int[] compressed = new int[sortedInt.length + 1024];
        IntWrapper inputoffset = new IntWrapper(0);
        IntWrapper outputoffset = new IntWrapper(1);
        codec.headlessCompress(sortedInt, inputoffset, sortedInt.length, compressed, outputoffset, new IntWrapper(0));
        compressed[0] = sortedInt.length;
        compressed = Arrays.copyOf(compressed, outputoffset.intValue());
        return compressed;
    }

    public static Compressor getMzCompressor(List<Compressor> compressors) {
        if (compressors == null) {
            return null;
        }
        for (Compressor compressor : compressors) {
            if (!compressor.getTarget().equals(Compressor.TARGET_MZ)) continue;
            return compressor;
        }
        return null;
    }

    public static Compressor getIntCompressor(List<Compressor> compressors) {
        if (compressors == null) {
            return null;
        }
        for (Compressor compressor : compressors) {
            if (!compressor.getTarget().equals(Compressor.TARGET_INTENSITY)) continue;
            return compressor;
        }
        return null;
    }

    public static String transToString(float[] target) {
        FloatBuffer fbTarget = FloatBuffer.wrap(target);
        ByteBuffer bbTarget = ByteBuffer.allocate(fbTarget.capacity() * 4);
        bbTarget.asFloatBuffer().put(fbTarget);
        byte[] targetArray = bbTarget.array();
        byte[] compressedArray = CompressUtil.zlibEncoder(targetArray);
        String targetStr = new String(new Base64().encode(compressedArray));
        return targetStr;
    }

    public static String transToString(int[] target) {
        IntBuffer ibTarget = IntBuffer.wrap(target);
        ByteBuffer bbTarget = ByteBuffer.allocate(ibTarget.capacity() * 4);
        bbTarget.asIntBuffer().put(ibTarget);
        byte[] targetArray = bbTarget.array();
        byte[] compressedArray = CompressUtil.zlibEncoder(targetArray);
        String targetStr = new String(new Base64().encode(compressedArray));
        return targetStr;
    }

    public static byte[] transToByte(short[] target) {
        ShortBuffer ibTarget = ShortBuffer.wrap(target);
        ByteBuffer bbTarget = ByteBuffer.allocate(ibTarget.capacity() * 2);
        bbTarget.order(ByteOrder.LITTLE_ENDIAN);
        bbTarget.asShortBuffer().put(ibTarget);
        byte[] targetArray = bbTarget.array();
        byte[] compressedArray = CompressUtil.zlibEncoder(targetArray);
        return compressedArray;
    }

    public static byte[] transToByte(int[] target) {
        IntBuffer ibTarget = IntBuffer.wrap(target);
        ByteBuffer bbTarget = ByteBuffer.allocate(ibTarget.capacity() * 4);
        bbTarget.order(ByteOrder.LITTLE_ENDIAN);
        bbTarget.asIntBuffer().put(ibTarget);
        byte[] targetArray = bbTarget.array();
        byte[] compressedArray = CompressUtil.zlibEncoder(targetArray);
        return compressedArray;
    }

    public static byte[] transToByte(float[] target) {
        FloatBuffer fbTarget = FloatBuffer.wrap(target);
        ByteBuffer bbTarget = ByteBuffer.allocate(fbTarget.capacity() * 4);
        bbTarget.asFloatBuffer().put(fbTarget);
        byte[] targetArray = bbTarget.array();
        byte[] compressedArray = CompressUtil.zlibEncoder(targetArray);
        return compressedArray;
    }

    public static float[] transToFloat(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(value);
        byteBuffer = ByteBuffer.wrap(CompressUtil.zlibDecoder(byteBuffer.array()));
        FloatBuffer floats = byteBuffer.asFloatBuffer();
        float[] floatValues = new float[floats.capacity()];
        for (int i = 0; i < floats.capacity(); ++i) {
            floatValues[i] = floats.get(i);
        }
        byteBuffer.clear();
        return floatValues;
    }

    public static int[] transToInteger(byte[] value, ByteOrder order) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(CompressUtil.zlibDecoder(value));
        if (order == null) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(order);
        }
        IntBuffer ints = byteBuffer.asIntBuffer();
        int[] intValues = new int[ints.capacity()];
        for (int i = 0; i < ints.capacity(); ++i) {
            intValues[i] = ints.get(i);
        }
        byteBuffer.clear();
        return intValues;
    }

    public static short[] transToShort(byte[] value, ByteOrder order) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(CompressUtil.zlibDecoder(value));
        if (order == null) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(order);
        }
        ShortBuffer shorts = byteBuffer.asShortBuffer();
        short[] shortValues = new short[shorts.capacity()];
        for (int i = 0; i < shorts.capacity(); ++i) {
            shortValues[i] = shorts.get(i);
        }
        byteBuffer.clear();
        return shortValues;
    }

    public static int[] transToInteger(byte[] value) {
        return CompressUtil.transToInteger(value, ByteOrder.LITTLE_ENDIAN);
    }

    public static short[] transToShort(byte[] value) {
        return CompressUtil.transToShort(value, ByteOrder.LITTLE_ENDIAN);
    }

    public static int[] bytesToInteger(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(value);
        IntBuffer ints = byteBuffer.asIntBuffer();
        int[] intValues = new int[ints.capacity()];
        for (int i = 0; i < ints.capacity(); ++i) {
            intValues[i] = ints.get(i);
        }
        byteBuffer.clear();
        return intValues;
    }
}

