/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class FeatureUtil {
    public static final String SP = ";";
    public static final String SSP = ":";

    public static final <T> String toString(Map<String, T> attrs) {
        StringBuilder sb = new StringBuilder();
        if (null != attrs && !attrs.isEmpty()) {
            Set<Map.Entry<String, T>> entrySet = attrs.entrySet();
            for (Map.Entry<String, T> entry : entrySet) {
                String key = entry.getKey();
                String val = entry.getValue().toString();
                sb.append(key).append(SSP).append(val).append(SP);
            }
        }
        return sb.toString();
    }

    public static final String toString(Double left, Double right) {
        return left.toString() + SP + right.toString();
    }

    public static final Pair<Double, Double> toDoublePair(String range) {
        String[] arr = range.split(SP);
        Double left = Double.parseDouble(arr[0]);
        Double right = Double.parseDouble(arr[1]);
        return Pair.of((Object)left, (Object)right);
    }

    public static final Map<String, Double> toDoubleMap(String str) {
        HashMap<String, Double> attrs = new HashMap<String, Double>();
        if (str != null) {
            String[] arr;
            for (String kv : arr = str.split(SP)) {
                String[] ar = kv.split(SSP);
                if (ar.length != 2) continue;
                String k = ar[0];
                Double v = Double.parseDouble(ar[1]);
                attrs.put(k, v);
            }
        }
        return attrs;
    }

    public static final HashMap<String, Float> toFloatMap(String str) {
        HashMap<String, Float> attrs = new HashMap<String, Float>();
        if (str != null) {
            String[] arr;
            for (String kv : arr = str.split(SP)) {
                String[] ar = kv.split(SSP);
                if (ar.length != 2) continue;
                String k = ar[0];
                Float v = Float.valueOf(Float.parseFloat(ar[1]));
                attrs.put(k, v);
            }
        }
        return attrs;
    }
}

