/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static String readFile(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int fileLength = fis.available();
            byte[] bytes = new byte[fileLength];
            fis.read(bytes);
            return new String(bytes, 0, fileLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtil.close(fis);
            return null;
        }
    }

    public static String readFile(String filePath) {
        File file = new File(filePath);
        return FileUtil.readFile(file);
    }

    public static String readFileFromSource(String filePath) throws IOException {
        File file = new File(FileUtil.class.getClassLoader().getResource(filePath).getPath());
        FileInputStream fis = new FileInputStream(file);
        int fileLength = fis.available();
        byte[] bytes = new byte[fileLength];
        fis.read(bytes);
        FileUtil.close(fis);
        return new String(bytes, 0, fileLength);
    }

    public static void close(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(FileWriter fw) {
        if (fw != null) {
            try {
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(BufferedWriter bw) {
        if (bw != null) {
            try {
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(FileOutputStream fos) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(InputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(BufferedOutputStream bos) {
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ByteArrayOutputStream baos) {
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(GZIPOutputStream bos) {
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ZipOutputStream bos) {
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

