/*
 * Decompiled with CFR 0.152.
 */
package net.csibio.aird.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.csibio.aird.bean.Layers;
import net.csibio.aird.util.CompressUtil;
import org.apache.commons.math3.util.FastMath;

public class StackCompressUtil {
    public static Layers stackEncode(List<int[]> arrGroup, boolean pair) {
        int stackLen = 0;
        for (int[] arr : arrGroup) {
            stackLen += arr.length;
        }
        ArrayList<int[]> tempArrGroup = new ArrayList<int[]>();
        for (int i = 0; i < arrGroup.size(); ++i) {
            tempArrGroup.add(Arrays.copyOf(arrGroup.get(i), arrGroup.get(i).length));
        }
        int[][] stackSort = pair ? StackCompressUtil.getPairSortArray(tempArrGroup) : StackCompressUtil.getQueueSortArray(tempArrGroup);
        int[] stackArr = new int[stackLen];
        int[] stackIndex = new int[stackLen];
        for (int i = 0; i < stackLen; ++i) {
            stackArr[i] = stackSort[i][0];
            stackIndex[i] = stackSort[i][1];
        }
        int digit = (int)Math.ceil(Math.log(arrGroup.size()) / Math.log(2.0));
        int indexLen = (stackLen * digit - 1) / 8 + 1;
        byte[] value = new byte[8 * indexLen];
        for (int i = 0; i < stackLen; ++i) {
            int fromIndex = digit * i;
            for (int j = 0; j < digit; ++j) {
                value[fromIndex + j] = (byte)(stackIndex[i] >> j & 1);
            }
        }
        byte[] indexShift = new byte[indexLen];
        for (int i = 0; i < indexLen; ++i) {
            int temp = 0;
            for (int j = 0; j < 8; ++j) {
                indexShift[i] = (byte)(temp += value[8 * i + j] << j);
            }
        }
        Layers layers = new Layers();
        layers.setMzArray(CompressUtil.transToByte(CompressUtil.fastPforEncoder(stackArr)));
        layers.setTagArray(CompressUtil.zlibEncoder(indexShift));
        layers.setDigit(digit);
        return layers;
    }

    public static List<int[]> stackDecode(Layers layers) {
        int j;
        int i;
        int[] stackArr = CompressUtil.fastPforDecoder(CompressUtil.transToInteger(layers.getMzArray()));
        int[] stackIndex = new int[stackArr.length];
        byte[] indexShift = CompressUtil.zlibDecoder(layers.getTagArray());
        int digit = layers.getDigit();
        byte[] value = new byte[8 * indexShift.length];
        for (i = 0; i < indexShift.length; ++i) {
            for (j = 0; j < 8; ++j) {
                value[8 * i + j] = (byte)((indexShift[i] & 0xFF) >> j & 1);
            }
        }
        for (i = 0; i < stackIndex.length; ++i) {
            for (j = 0; j < digit; ++j) {
                int n = i;
                stackIndex[n] = stackIndex[n] + (value[digit * i + j] << j);
            }
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int index : stackIndex) {
            map.merge(index, 1, Integer::sum);
        }
        ArrayList<int[]> arrGroup = new ArrayList<int[]>();
        int arrNum = map.keySet().size();
        for (int i2 = 0; i2 < arrNum; ++i2) {
            arrGroup.add(new int[((Integer)map.get(i2)).intValue()]);
        }
        int[] p = new int[arrNum];
        for (int i3 = 0; i3 < stackIndex.length; ++i3) {
            int n = stackIndex[i3];
            int n2 = p[n];
            p[n] = n2 + 1;
            ((int[])arrGroup.get((int)stackIndex[i3]))[n2] = stackArr[i3];
        }
        return arrGroup;
    }

    private static int[][] getFullSortArray(List<int[]> arrGroup) {
        int stackLen = 0;
        for (int[] arr : arrGroup) {
            stackLen += arr.length;
        }
        int[][] stackSort = new int[stackLen][2];
        int index = 0;
        int arrLen = 0;
        for (int[] arr : arrGroup) {
            for (int i = 0; i < arr.length; ++i) {
                stackSort[i + arrLen][0] = arr[i];
                stackSort[i + arrLen][1] = index;
            }
            ++index;
            arrLen += arr.length;
        }
        Arrays.sort(stackSort, Comparator.comparingInt(a -> a[0]));
        return stackSort;
    }

    private static int[][] getPairSortArray(List<int[]> arrGroup) {
        ArrayList<int[]> indexGroup = new ArrayList<int[]>();
        indexGroup.add(new int[arrGroup.get(0).length]);
        for (int i = 1; i < arrGroup.size(); ++i) {
            int[] indexes = new int[arrGroup.get(i).length];
            Arrays.fill(indexes, i);
            indexGroup.add(indexes);
        }
        int mergeTimes = (int)FastMath.log((double)2.0, (double)arrGroup.size());
        for (int i = 1; i <= mergeTimes; ++i) {
            int stepWidth = (int)Math.pow(2.0, i);
            int tempMergeTime = arrGroup.size() / stepWidth;
            for (int j = 0; j < tempMergeTime; ++j) {
                int leftIndex = j * stepWidth;
                int rightIndex = leftIndex + stepWidth / 2;
                int[] dataArr1 = arrGroup.get(leftIndex);
                int[] dataArr2 = arrGroup.get(rightIndex);
                int[] indexArr1 = (int[])indexGroup.get(leftIndex);
                int[] indexArr2 = (int[])indexGroup.get(rightIndex);
                int[] dataArr = new int[dataArr1.length + dataArr2.length];
                int[] indexArr = new int[dataArr.length];
                int index1 = 0;
                int index2 = 0;
                int index = 0;
                for (int k = 0; k < dataArr.length; ++k) {
                    if (index1 >= dataArr1.length) {
                        dataArr[index] = dataArr2[index2];
                        indexArr[index] = indexArr2[index2];
                        ++index2;
                        ++index;
                        continue;
                    }
                    if (index2 >= dataArr2.length) {
                        dataArr[index] = dataArr1[index1];
                        indexArr[index] = indexArr1[index1];
                        ++index1;
                        ++index;
                        continue;
                    }
                    if (dataArr1[index1] <= dataArr2[index2]) {
                        dataArr[index] = dataArr1[index1];
                        indexArr[index] = indexArr1[index1];
                        ++index1;
                    } else {
                        dataArr[index] = dataArr2[index2];
                        indexArr[index] = indexArr2[index2];
                        ++index2;
                    }
                    ++index;
                }
                indexGroup.set(leftIndex, indexArr);
                arrGroup.set(leftIndex, dataArr);
            }
        }
        int[] arr = arrGroup.get(0);
        int[] index = (int[])indexGroup.get(0);
        int[][] resultArr = new int[arr.length][2];
        for (int i = 0; i < resultArr.length; ++i) {
            resultArr[i][0] = arr[i];
            resultArr[i][1] = index[i];
        }
        return resultArr;
    }

    private static int[][] getQueueSortArray(List<int[]> arrGroup) {
        int stackLen = 0;
        for (int[] arr : arrGroup) {
            stackLen += arr.length;
        }
        int[][] resultArr = new int[stackLen][2];
        int[] indexes = new int[arrGroup.size()];
        Arrays.fill(indexes, 1);
        PriorityQueue<int[]> priorityQueue = new PriorityQueue<int[]>(new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return Integer.compare(o1[0], o2[0]);
            }
        });
        int i = 0;
        while (i < arrGroup.size()) {
            priorityQueue.offer(new int[]{arrGroup.get(i)[0], i++});
        }
        for (i = 0; i < stackLen; ++i) {
            int[] node = priorityQueue.poll();
            resultArr[i] = node;
            int groupIndex = node[1];
            int index = indexes[groupIndex];
            if (index >= arrGroup.get(groupIndex).length) continue;
            priorityQueue.offer(new int[]{arrGroup.get(groupIndex)[index], groupIndex});
            int n = groupIndex;
            indexes[n] = indexes[n] + 1;
        }
        return resultArr;
    }
}

