/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Properties;
import liquibase.ext.hibernate.database.ConfigType;

public class ConfigLocator {
    private String url;
    private ConfigType type;
    private String path;
    private Properties properties;

    public ConfigLocator(String url) {
        this.url = url;
        this.type = ConfigType.forUrl(url);
        if (this.type == null) {
            throw new IllegalStateException("Unsupported URL format: " + url);
        }
        this.path = url.substring(this.type.getPrefix().length() + 1);
        this.properties = new Properties();
        int queryIndex = this.path.indexOf(63);
        if (queryIndex >= 0) {
            this.loadProperties(this.path.substring(queryIndex + 1));
            this.path = this.path.substring(0, queryIndex);
        }
    }

    private void loadProperties(String query) {
        query = query.replaceAll("&", System.getProperty("line.separator"));
        try {
            query = URLDecoder.decode(query, "UTF-8");
            this.properties.load(new StringReader(query));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to read properties from url", ioe);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public ConfigType getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        return ((ConfigLocator)obj).url.equals(this.url);
    }

    public int hashCode() {
        return 7 + this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }
}

