/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;

public class HibernateGenericDialect
extends Dialect {
    private Dialect realDialect;

    public HibernateGenericDialect(Configuration cfg) throws Exception {
        String dialectClass = cfg.getProperty("hibernate.dialect");
        if (dialectClass == null) {
            dialectClass = cfg.getProperty("dialect");
        }
        this.realDialect = (Dialect)Class.forName(dialectClass).newInstance();
    }

    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        if (code == -5) {
            return "bigint";
        }
        if (code == 16) {
            return "boolean";
        }
        if (code == 2004) {
            return "blob";
        }
        if (code == 2005) {
            return "clob";
        }
        if (code == 91) {
            return "date";
        }
        if (code == 6) {
            return "float";
        }
        if (code == 92) {
            return "time";
        }
        if (code == 93) {
            return "datetime";
        }
        if (code == 12) {
            return "varchar";
        }
        if (code == -9) {
            return "nvarchar";
        }
        return this.realDialect.getTypeName(code, length, precision, scale);
    }
}

