/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.database.HibernateGenericDialect;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGenerator;
import liquibase.util.StringUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class HibernateDatabaseSnapshotGenerator
implements DatabaseSnapshotGenerator {
    private HibernateDatabase database;

    public liquibase.database.structure.Table getDatabaseChangeLogTable(Database database) throws DatabaseException {
        return null;
    }

    public liquibase.database.structure.Table getDatabaseChangeLogLockTable(Database database) throws DatabaseException {
        return null;
    }

    public liquibase.database.structure.Table getTable(String schemaName, String tableName, Database database) throws DatabaseException {
        return null;
    }

    public liquibase.database.structure.Column getColumn(String schemaName, String tableName, String columnName, Database database) throws DatabaseException {
        return null;
    }

    public boolean hasIndex(String s, String s1, String s2, Database database) throws DatabaseException {
        return false;
    }

    public boolean hasDatabaseChangeLogTable(Database database) {
        return false;
    }

    public boolean hasDatabaseChangeLogLockTable(Database database) {
        return false;
    }

    public boolean hasTable(String schemaName, String tableName, Database database) {
        return false;
    }

    public boolean hasView(String s, String s2, Database database) {
        return false;
    }

    public ForeignKey getForeignKeyByForeignKeyTable(String schemaName, String tableName, String fkName, Database database) throws DatabaseException {
        return null;
    }

    public List<ForeignKey> getForeignKeys(String schemaName, String tableName, Database database) throws DatabaseException {
        return new ArrayList<ForeignKey>();
    }

    public DatabaseSnapshot createSnapshot(Database passed, String schema, Set<DiffStatusListener> listeners) throws DatabaseException {
        HibernateDatabase database = (HibernateDatabase)passed;
        try {
            Table hibernateTable;
            Configuration cfg = database.createConfiguration();
            this.database = database;
            HibernateGenericDialect dialect = new HibernateGenericDialect(cfg);
            cfg.buildMappings();
            Mapping mapping = cfg.buildMapping();
            DatabaseSnapshot snapshot = new DatabaseSnapshot((Database)database, schema);
            Iterator tableMappings = cfg.getTableMappings();
            while (tableMappings.hasNext()) {
                hibernateTable = (Table)tableMappings.next();
                if (!hibernateTable.isPhysicalTable()) continue;
                liquibase.database.structure.Table table = new liquibase.database.structure.Table(hibernateTable.getName());
                snapshot.getTables().add(table);
                System.out.println("seen table " + table.getName());
                Iterator columnIterator = hibernateTable.getColumnIterator();
                while (columnIterator.hasNext()) {
                    Column hibernateColumn = (Column)columnIterator.next();
                    liquibase.database.structure.Column column = new liquibase.database.structure.Column();
                    column.setName(hibernateColumn.getName());
                    column.setDataType(hibernateColumn.getSqlTypeCode(mapping));
                    if (column.isNumeric()) {
                        column.setColumnSize(hibernateColumn.getPrecision());
                    } else {
                        column.setColumnSize(hibernateColumn.getLength());
                    }
                    column.setDecimalDigits(hibernateColumn.getScale());
                    column.setDefaultValue((Object)hibernateColumn.getDefaultValue());
                    column.setNullable(Boolean.valueOf(hibernateColumn.isNullable()));
                    column.setPrimaryKey(this.isPrimaryKey(hibernateTable, hibernateColumn));
                    column.setTable(table);
                    column.setTypeName(hibernateColumn.getSqlType((Dialect)dialect, mapping).replaceFirst("\\(.*\\)", ""));
                    column.setUnique(hibernateColumn.isUnique());
                    column.setCertainDataType(false);
                    table.getColumns().add(column);
                }
                Iterator indexIterator = hibernateTable.getIndexIterator();
                while (indexIterator.hasNext()) {
                    org.hibernate.mapping.Index hibernateIndex = (org.hibernate.mapping.Index)indexIterator.next();
                    Index index = new Index();
                    index.setTable(table);
                    index.setName(hibernateIndex.getName());
                    columnIterator = hibernateIndex.getColumnIterator();
                    while (columnIterator.hasNext()) {
                        Column hibernateColumn = (Column)columnIterator.next();
                        index.getColumns().add(hibernateColumn.getName());
                    }
                    snapshot.getIndexes().add(index);
                }
                Iterator uniqueIterator = hibernateTable.getUniqueKeyIterator();
                while (uniqueIterator.hasNext()) {
                    UniqueKey hiberateUnique = (UniqueKey)uniqueIterator.next();
                    Index index = new Index();
                    index.setTable(table);
                    index.setName(hiberateUnique.getName());
                    columnIterator = hiberateUnique.getColumnIterator();
                    while (columnIterator.hasNext()) {
                        Column hibernateColumn = (Column)columnIterator.next();
                        index.getColumns().add(hibernateColumn.getName());
                    }
                    snapshot.getIndexes().add(index);
                }
                org.hibernate.mapping.PrimaryKey hibernatePrimaryKey = hibernateTable.getPrimaryKey();
                if (hibernatePrimaryKey == null) continue;
                PrimaryKey pk = new PrimaryKey();
                pk.setName(hibernatePrimaryKey.getName());
                pk.setTable(table);
                for (Object hibernateColumn : hibernatePrimaryKey.getColumns()) {
                    pk.getColumnNamesAsList().add(((Column)hibernateColumn).getName());
                }
                snapshot.getPrimaryKeys().add(pk);
            }
            tableMappings = cfg.getTableMappings();
            while (tableMappings.hasNext()) {
                hibernateTable = (Table)tableMappings.next();
                if (!hibernateTable.isPhysicalTable()) continue;
                Iterator fkIterator = hibernateTable.getForeignKeyIterator();
                while (fkIterator.hasNext()) {
                    org.hibernate.mapping.ForeignKey hibernateForeignKey = (org.hibernate.mapping.ForeignKey)fkIterator.next();
                    if (hibernateForeignKey.getTable() == null || hibernateForeignKey.getReferencedTable() == null || !hibernateForeignKey.isPhysicalConstraint()) continue;
                    ForeignKey fk = new ForeignKey();
                    fk.setName(hibernateForeignKey.getName());
                    fk.setForeignKeyTable(snapshot.getTable(hibernateForeignKey.getTable().getName()));
                    ArrayList<String> fkColumns = new ArrayList<String>();
                    for (Object column : hibernateForeignKey.getColumns()) {
                        fkColumns.add(((Column)column).getName());
                    }
                    fk.setForeignKeyColumns(StringUtils.join(fkColumns, (String)", "));
                    fk.setPrimaryKeyTable(snapshot.getTable(hibernateForeignKey.getReferencedTable().getName()));
                    fkColumns = new ArrayList();
                    for (Object column : hibernateForeignKey.getReferencedColumns()) {
                        fkColumns.add(((Column)column).getName());
                    }
                    if (fkColumns.size() == 0) {
                        for (Object column : hibernateForeignKey.getReferencedTable().getPrimaryKey().getColumns()) {
                            fkColumns.add(((Column)column).getName());
                        }
                    }
                    fk.setPrimaryKeyColumns(StringUtils.join(fkColumns, (String)", "));
                    snapshot.getForeignKeys().add(fk);
                }
            }
            return snapshot;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public boolean supports(Database database) {
        return database instanceof HibernateDatabase;
    }

    public int getPriority(Database database) {
        return 5;
    }

    public boolean hasDatabaseChangeLogLockTable() {
        return true;
    }

    public liquibase.database.structure.Table getDatabaseChangeLogTable() {
        return null;
    }

    private boolean isPrimaryKey(Table hibernateTable, Column hibernateColumn) {
        org.hibernate.mapping.PrimaryKey key = hibernateTable.getPrimaryKey();
        if (key == null) {
            return false;
        }
        Iterator columnIterator = key.getColumnIterator();
        while (columnIterator.hasNext()) {
            if (!columnIterator.next().equals(hibernateColumn)) continue;
            return true;
        }
        return false;
    }

    public Database getDatabase() {
        return this.database;
    }

    public boolean hasIndex(String s, String s1, String s2, Database database, String s3) throws DatabaseException {
        return false;
    }
}

