/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;

public abstract class PreciseDurationDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 5004523158306266035L;
    final long iUnitMillis;
    private final DurationField iUnitField;

    public PreciseDurationDateTimeField(DateTimeFieldType type, DurationField unit) {
        super(type);
        if (!unit.isPrecise()) {
            throw new IllegalArgumentException("Unit duration field must be precise");
        }
        this.iUnitMillis = unit.getUnitMillis();
        if (this.iUnitMillis < 1L) {
            throw new IllegalArgumentException("The unit milliseconds must be at least 1");
        }
        this.iUnitField = unit;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, this.getMinimumValue(), this.getMaximumValueForSet(instant, value));
        return instant + (long)(value - this.get(instant)) * this.iUnitMillis;
    }

    @Override
    public long roundFloor(long instant) {
        if (instant >= 0L) {
            return instant - instant % this.iUnitMillis;
        }
        return ++instant - instant % this.iUnitMillis - this.iUnitMillis;
    }

    @Override
    public long roundCeiling(long instant) {
        if (instant > 0L) {
            return --instant - instant % this.iUnitMillis + this.iUnitMillis;
        }
        return instant - instant % this.iUnitMillis;
    }

    @Override
    public long remainder(long instant) {
        if (instant >= 0L) {
            return instant % this.iUnitMillis;
        }
        return (instant + 1L) % this.iUnitMillis + this.iUnitMillis - 1L;
    }

    @Override
    public DurationField getDurationField() {
        return this.iUnitField;
    }

    @Override
    public int getMinimumValue() {
        return 0;
    }

    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    protected int getMaximumValueForSet(long instant, int value) {
        return this.getMaximumValue(instant);
    }
}

