/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ScaledDurationField;

public class RemainderDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 5708241235177666790L;
    final int iDivisor;
    final DurationField iDurationField;
    final DurationField iRangeField;

    public RemainderDateTimeField(DateTimeField field, DateTimeFieldType type, int divisor) {
        super(field, type);
        if (divisor < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField rangeField = field.getDurationField();
        this.iRangeField = rangeField == null ? null : new ScaledDurationField(rangeField, type.getRangeDurationType(), divisor);
        this.iDurationField = field.getDurationField();
        this.iDivisor = divisor;
    }

    public RemainderDateTimeField(DateTimeField field, DurationField rangeField, DateTimeFieldType type, int divisor) {
        super(field, type);
        if (divisor < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        this.iRangeField = rangeField;
        this.iDurationField = field.getDurationField();
        this.iDivisor = divisor;
    }

    public RemainderDateTimeField(DividedDateTimeField dividedField) {
        this(dividedField, dividedField.getType());
    }

    public RemainderDateTimeField(DividedDateTimeField dividedField, DateTimeFieldType type) {
        this(dividedField, dividedField.getWrappedField().getDurationField(), type);
    }

    public RemainderDateTimeField(DividedDateTimeField dividedField, DurationField durationField, DateTimeFieldType type) {
        super(dividedField.getWrappedField(), type);
        this.iDivisor = dividedField.iDivisor;
        this.iDurationField = durationField;
        this.iRangeField = dividedField.iDurationField;
    }

    @Override
    public int get(long instant) {
        int value = this.getWrappedField().get(instant);
        if (value >= 0) {
            return value % this.iDivisor;
        }
        return this.iDivisor - 1 + (value + 1) % this.iDivisor;
    }

    @Override
    public long addWrapField(long instant, int amount) {
        return this.set(instant, FieldUtils.getWrappedValue(this.get(instant), amount, 0, this.iDivisor - 1));
    }

    @Override
    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, 0, this.iDivisor - 1);
        int divided = this.getDivided(this.getWrappedField().get(instant));
        return this.getWrappedField().set(instant, divided * this.iDivisor + value);
    }

    @Override
    public DurationField getDurationField() {
        return this.iDurationField;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    @Override
    public int getMinimumValue() {
        return 0;
    }

    @Override
    public int getMaximumValue() {
        return this.iDivisor - 1;
    }

    @Override
    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    @Override
    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    @Override
    public long roundHalfFloor(long instant) {
        return this.getWrappedField().roundHalfFloor(instant);
    }

    @Override
    public long roundHalfCeiling(long instant) {
        return this.getWrappedField().roundHalfCeiling(instant);
    }

    @Override
    public long roundHalfEven(long instant) {
        return this.getWrappedField().roundHalfEven(instant);
    }

    @Override
    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    private int getDivided(int value) {
        if (value >= 0) {
            return value / this.iDivisor;
        }
        return (value + 1) / this.iDivisor - 1;
    }
}

