/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.SkipUndoDateTimeField;
import org.joda.time.field.UnsupportedDurationField;

public final class BuddhistChronology
extends AssembledChronology {
    private static final long serialVersionUID = -3474595157769370126L;
    public static final int BE = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("BE");
    private static final int BUDDHIST_OFFSET = 543;
    private static final Map<DateTimeZone, BuddhistChronology> cCache = new HashMap<DateTimeZone, BuddhistChronology>();
    private static final BuddhistChronology INSTANCE_UTC = BuddhistChronology.getInstance(DateTimeZone.UTC);

    public static BuddhistChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static BuddhistChronology getInstance() {
        return BuddhistChronology.getInstance(DateTimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BuddhistChronology getInstance(DateTimeZone zone) {
        BuddhistChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, BuddhistChronology> map = cCache;
        synchronized (map) {
            chrono = cCache.get(zone);
            if (chrono == null) {
                chrono = new BuddhistChronology(GJChronology.getInstance(zone, null), null);
                DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                chrono = new BuddhistChronology(LimitChronology.getInstance(chrono, lowerLimit, null), "");
                cCache.put(zone, chrono);
            }
        }
        return chrono;
    }

    private BuddhistChronology(Chronology base, Object param) {
        super(base, param);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? BuddhistChronology.getInstanceUTC() : BuddhistChronology.getInstance(base.getZone());
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return BuddhistChronology.getInstance(zone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BuddhistChronology) {
            BuddhistChronology chrono = (BuddhistChronology)obj;
            return this.getZone().equals(chrono.getZone());
        }
        return false;
    }

    public int hashCode() {
        return "Buddhist".hashCode() * 11 + this.getZone().hashCode();
    }

    @Override
    public String toString() {
        String str = "BuddhistChronology";
        DateTimeZone zone = this.getZone();
        if (zone != null) {
            str = str + '[' + zone.getID() + ']';
        }
        return str;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getParam() == null) {
            fields.eras = UnsupportedDurationField.getInstance(DurationFieldType.eras());
            DateTimeField field = fields.year;
            fields.year = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, field), 543);
            field = fields.yearOfEra;
            fields.yearOfEra = new DelegatedDateTimeField(fields.year, fields.eras, DateTimeFieldType.yearOfEra());
            field = fields.weekyear;
            fields.weekyear = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, field), 543);
            field = new OffsetDateTimeField(fields.yearOfEra, 99);
            fields.centuryOfEra = new DividedDateTimeField(field, fields.eras, DateTimeFieldType.centuryOfEra(), 100);
            fields.centuries = fields.centuryOfEra.getDurationField();
            field = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra);
            fields.yearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.yearOfCentury(), 1);
            field = new RemainderDateTimeField(fields.weekyear, fields.centuries, DateTimeFieldType.weekyearOfCentury(), 100);
            fields.weekyearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.weekyearOfCentury(), 1);
            fields.era = ERA_FIELD;
        }
    }
}

