/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.BuddhistChronology;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.JulianChronology;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.PartialConverter;

final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();

    protected CalendarConverter() {
    }

    @Override
    public Chronology getChronology(Object object, Chronology chrono) {
        if (chrono != null) {
            return chrono;
        }
        Calendar cal = (Calendar)object;
        DateTimeZone zone = null;
        try {
            zone = DateTimeZone.forTimeZone(cal.getTimeZone());
        }
        catch (IllegalArgumentException ex) {
            zone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)cal, zone);
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone zone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(zone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)object;
            long cutover = gc.getGregorianChange().getTime();
            if (cutover == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(zone);
            }
            if (cutover == Long.MAX_VALUE) {
                return JulianChronology.getInstance(zone);
            }
            return GJChronology.getInstance(zone, cutover, 4);
        }
        return ISOChronology.getInstance(zone);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chrono) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    @Override
    public Class<?> getSupportedType() {
        return Calendar.class;
    }
}

