/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDurationField;

final class GJEraDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 4240986525305515528L;
    private final BasicChronology iChronology;

    GJEraDateTimeField(BasicChronology chronology) {
        super(DateTimeFieldType.era());
        this.iChronology = chronology;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long instant) {
        if (this.iChronology.getYear(instant) <= 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getAsText(int fieldValue, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).eraValueToText(fieldValue);
    }

    @Override
    public long set(long instant, int era) {
        FieldUtils.verifyValueBounds(this, era, 0, 1);
        int oldEra = this.get(instant);
        if (oldEra != era) {
            int year = this.iChronology.getYear(instant);
            return this.iChronology.setYear(instant, -year);
        }
        return instant;
    }

    @Override
    public long set(long instant, String text, Locale locale) {
        return this.set(instant, GJLocaleSymbols.forLocale(locale).eraTextToValue(text));
    }

    @Override
    public long roundFloor(long instant) {
        if (this.get(instant) == 1) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long roundCeiling(long instant) {
        if (this.get(instant) == 0) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long roundHalfFloor(long instant) {
        return this.roundFloor(instant);
    }

    @Override
    public long roundHalfCeiling(long instant) {
        return this.roundFloor(instant);
    }

    @Override
    public long roundHalfEven(long instant) {
        return this.roundFloor(instant);
    }

    @Override
    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public int getMinimumValue() {
        return 0;
    }

    @Override
    public int getMaximumValue() {
        return 1;
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getEraMaxTextLength();
    }

    private Object readResolve() {
        return this.iChronology.era();
    }
}

