/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicWeekOfWeekyearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -1587436826395135328L;
    private final BasicChronology iChronology;

    BasicWeekOfWeekyearDateTimeField(BasicChronology chronology, DurationField weeks) {
        super(DateTimeFieldType.weekOfWeekyear(), weeks);
        this.iChronology = chronology;
    }

    @Override
    public int get(long instant) {
        return this.iChronology.getWeekOfWeekyear(instant);
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.weekyears();
    }

    @Override
    public long roundFloor(long instant) {
        return super.roundFloor(instant + 259200000L) - 259200000L;
    }

    @Override
    public long roundCeiling(long instant) {
        return super.roundCeiling(instant + 259200000L) - 259200000L;
    }

    @Override
    public long remainder(long instant) {
        return super.remainder(instant + 259200000L);
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return 53;
    }

    @Override
    public int getMaximumValue(long instant) {
        int weekyear = this.iChronology.getWeekyear(instant);
        return this.iChronology.getWeeksInYear(weekyear);
    }

    @Override
    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.weekyear())) {
            int weekyear = partial.get(DateTimeFieldType.weekyear());
            return this.iChronology.getWeeksInYear(weekyear);
        }
        return 53;
    }

    @Override
    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        for (int i = 0; i < size; ++i) {
            if (partial.getFieldType(i) != DateTimeFieldType.weekyear()) continue;
            int weekyear = values[i];
            return this.iChronology.getWeeksInYear(weekyear);
        }
        return 53;
    }

    @Override
    protected int getMaximumValueForSet(long instant, int value) {
        return value > 52 ? this.getMaximumValue(instant) : 52;
    }

    private Object readResolve() {
        return this.iChronology.weekOfWeekyear();
    }
}

