/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicGJChronology
extends BasicChronology {
    private static final long serialVersionUID = 538276888268L;
    private static final int[] MIN_DAYS_PER_MONTH_ARRAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] MAX_DAYS_PER_MONTH_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long[] MIN_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
    private static final long[] MAX_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
    private static final long FEB_29 = 5097600000L;

    BasicGJChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    @Override
    boolean isLeapDay(long instant) {
        return this.dayOfMonth().get(instant) == 29 && this.monthOfYear().isLeap(instant);
    }

    @Override
    int getMonthOfYear(long millis, int year) {
        int i = (int)(millis - this.getYearMillis(year) >> 10);
        return this.isLeapYear(year) ? (i < 15356250 ? (i < 7678125 ? (i < 2615625 ? 1 : (i < 5062500 ? 2 : 3)) : (i < 10209375 ? 4 : (i < 12825000 ? 5 : 6))) : (i < 23118750 ? (i < 17971875 ? 7 : (i < 20587500 ? 8 : 9)) : (i < 25734375 ? 10 : (i < 28265625 ? 11 : 12)))) : (i < 15271875 ? (i < 7593750 ? (i < 2615625 ? 1 : (i < 4978125 ? 2 : 3)) : (i < 10125000 ? 4 : (i < 12740625 ? 5 : 6))) : (i < 23034375 ? (i < 17887500 ? 7 : (i < 20503125 ? 8 : 9)) : (i < 25650000 ? 10 : (i < 28181250 ? 11 : 12))));
    }

    @Override
    int getDaysInYearMonth(int year, int month) {
        if (this.isLeapYear(year)) {
            return MAX_DAYS_PER_MONTH_ARRAY[month - 1];
        }
        return MIN_DAYS_PER_MONTH_ARRAY[month - 1];
    }

    @Override
    int getDaysInMonthMax(int month) {
        return MAX_DAYS_PER_MONTH_ARRAY[month - 1];
    }

    @Override
    int getDaysInMonthMaxForSet(long instant, int value) {
        return value > 28 || value < 1 ? this.getDaysInMonthMax(instant) : 28;
    }

    @Override
    long getTotalMillisByYearMonth(int year, int month) {
        if (this.isLeapYear(year)) {
            return MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[month - 1];
        }
        return MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[month - 1];
    }

    @Override
    long getYearDifference(long minuendInstant, long subtrahendInstant) {
        int minuendYear = this.getYear(minuendInstant);
        int subtrahendYear = this.getYear(subtrahendInstant);
        long minuendRem = minuendInstant - this.getYearMillis(minuendYear);
        long subtrahendRem = subtrahendInstant - this.getYearMillis(subtrahendYear);
        if (subtrahendRem >= 5097600000L) {
            if (this.isLeapYear(subtrahendYear)) {
                if (!this.isLeapYear(minuendYear)) {
                    subtrahendRem -= 86400000L;
                }
            } else if (minuendRem >= 5097600000L && this.isLeapYear(minuendYear)) {
                minuendRem -= 86400000L;
            }
        }
        int difference = minuendYear - subtrahendYear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    @Override
    long setYear(long instant, int year) {
        int thisYear = this.getYear(instant);
        int dayOfYear = this.getDayOfYear(instant, thisYear);
        int millisOfDay = this.getMillisOfDay(instant);
        if (dayOfYear > 59) {
            if (this.isLeapYear(thisYear)) {
                if (!this.isLeapYear(year)) {
                    --dayOfYear;
                }
            } else if (this.isLeapYear(year)) {
                ++dayOfYear;
            }
        }
        instant = this.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    static {
        long minSum = 0L;
        long maxSum = 0L;
        for (int i = 0; i < 11; ++i) {
            long millis = (long)MIN_DAYS_PER_MONTH_ARRAY[i] * 86400000L;
            BasicGJChronology.MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[i + 1] = minSum += millis;
            millis = (long)MAX_DAYS_PER_MONTH_ARRAY[i] * 86400000L;
            BasicGJChronology.MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[i + 1] = maxSum += millis;
        }
    }
}

