/*
 * Decompiled with CFR 0.152.
 */
package net.danlew.android.joda;

import android.content.Context;
import android.content.res.Resources;
import net.danlew.android.joda.R;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;

public class DateUtils {
    public static final int FORMAT_SHOW_TIME = 1;
    public static final int FORMAT_SHOW_WEEKDAY = 2;
    public static final int FORMAT_SHOW_YEAR = 4;
    public static final int FORMAT_NO_YEAR = 8;
    public static final int FORMAT_SHOW_DATE = 16;
    public static final int FORMAT_NO_MONTH_DAY = 32;
    public static final int FORMAT_NO_NOON = 512;
    public static final int FORMAT_NO_MIDNIGHT = 2048;
    public static final int FORMAT_ABBREV_TIME = 16384;
    public static final int FORMAT_ABBREV_WEEKDAY = 32768;
    public static final int FORMAT_ABBREV_MONTH = 65536;
    public static final int FORMAT_NUMERIC_DATE = 131072;
    public static final int FORMAT_ABBREV_RELATIVE = 262144;
    public static final int FORMAT_ABBREV_ALL = 524288;
    private static final int FORMAT_UTC = 8192;
    private static final DateTime EPOCH = new DateTime(0L, DateTimeZone.UTC);

    public static String formatDateTime(Context context, ReadablePartial time, int flags) {
        return android.text.format.DateUtils.formatDateTime((Context)context, (long)DateUtils.toMillis(time), (int)(flags | 0x2000));
    }

    public static String formatDateTime(Context context, ReadableInstant time, int flags) {
        return android.text.format.DateUtils.formatDateTime((Context)context, (long)DateUtils.toMillis(time), (int)(flags | 0x2000));
    }

    public static String formatDateRange(Context context, ReadablePartial start, ReadablePartial end, int flags) {
        return DateUtils.formatDateRange(context, DateUtils.toMillis(start), DateUtils.toMillis(end), flags);
    }

    public static String formatDateRange(Context context, ReadableInstant start, ReadableInstant end, int flags) {
        return DateUtils.formatDateRange(context, DateUtils.toMillis(start), DateUtils.toMillis(end), flags);
    }

    private static String formatDateRange(Context context, long startMillis, long endMillis, int flags) {
        if (startMillis != endMillis) {
            endMillis += 1000L;
        }
        return android.text.format.DateUtils.formatDateRange((Context)context, (long)startMillis, (long)endMillis, (int)(flags | 0x2000));
    }

    private static long toMillis(ReadablePartial time) {
        return time.toDateTime(EPOCH).getMillis();
    }

    private static long toMillis(ReadableInstant time) {
        DateTime dateTime = time instanceof DateTime ? (DateTime)time : new DateTime(time);
        DateTime utcDateTime = dateTime.withZoneRetainFields(DateTimeZone.UTC);
        return utcDateTime.getMillis();
    }

    public static String formatElapsedTime(ReadableDuration elapsedDuration) {
        return DateUtils.formatElapsedTime(null, elapsedDuration);
    }

    public static String formatElapsedTime(StringBuilder recycle, ReadableDuration elapsedDuration) {
        return android.text.format.DateUtils.formatElapsedTime((StringBuilder)recycle, (long)elapsedDuration.toDuration().toStandardSeconds().getSeconds());
    }

    public static boolean isToday(ReadablePartial time) {
        if (!(time.isSupported(DateTimeFieldType.dayOfMonth()) && time.isSupported(DateTimeFieldType.monthOfYear()) && time.isSupported(DateTimeFieldType.year()))) {
            throw new IllegalArgumentException("isToday() must be passed a ReadablePartial that supports day of month, month of year and year.");
        }
        LocalDate localDate = time instanceof LocalDate ? (LocalDate)time : new LocalDate(time);
        return LocalDate.now().compareTo(localDate) == 0;
    }

    public static boolean isToday(ReadableInstant time) {
        return LocalDate.now().compareTo(new LocalDate(time)) == 0;
    }

    public static CharSequence getRelativeTimeSpanString(Context context, ReadablePartial time) {
        return DateUtils.getRelativeTimeSpanString(context, time.toDateTime(DateTime.now()));
    }

    public static CharSequence getRelativeTimeSpanString(Context context, ReadableInstant time) {
        int flags = 65556;
        return DateUtils.getRelativeTimeSpanString(context, time, flags);
    }

    public static CharSequence getRelativeTimeSpanString(Context context, ReadablePartial time, int flags) {
        return DateUtils.getRelativeTimeSpanString(context, (ReadableInstant)time.toDateTime(DateTime.now()), flags);
    }

    public static CharSequence getRelativeTimeSpanString(Context context, ReadableInstant time, int flags) {
        int resId;
        long count;
        Interval interval;
        boolean abbrevRelative = (flags & 0xC0000) != 0;
        DateTime now = DateTime.now(time.getZone()).withMillisOfSecond(0);
        DateTime timeDt = new DateTime(time).withMillisOfSecond(0);
        boolean past = !now.isBefore(timeDt);
        Interval interval2 = interval = past ? new Interval((ReadableInstant)timeDt, (ReadableInstant)now) : new Interval((ReadableInstant)now, (ReadableInstant)timeDt);
        if (Minutes.minutesIn(interval).isLessThan(Minutes.ONE)) {
            count = Seconds.secondsIn(interval).getSeconds();
            resId = past ? (abbrevRelative ? R.plurals.abbrev_num_seconds_ago : R.plurals.num_seconds_ago) : (abbrevRelative ? R.plurals.abbrev_in_num_seconds : R.plurals.in_num_seconds);
        } else if (Hours.hoursIn(interval).isLessThan(Hours.ONE)) {
            count = Minutes.minutesIn(interval).getMinutes();
            resId = past ? (abbrevRelative ? R.plurals.abbrev_num_minutes_ago : R.plurals.num_minutes_ago) : (abbrevRelative ? R.plurals.abbrev_in_num_minutes : R.plurals.in_num_minutes);
        } else if (Days.daysIn(interval).isLessThan(Days.ONE)) {
            count = Hours.hoursIn(interval).getHours();
            resId = past ? (abbrevRelative ? R.plurals.abbrev_num_hours_ago : R.plurals.num_hours_ago) : (abbrevRelative ? R.plurals.abbrev_in_num_hours : R.plurals.in_num_hours);
        } else if (Weeks.weeksIn(interval).isLessThan(Weeks.ONE)) {
            count = Days.daysIn(interval).getDays();
            resId = past ? (abbrevRelative ? R.plurals.abbrev_num_days_ago : R.plurals.num_days_ago) : (abbrevRelative ? R.plurals.abbrev_in_num_days : R.plurals.in_num_days);
        } else {
            return DateUtils.formatDateRange(context, time, time, flags);
        }
        String format = context.getResources().getQuantityString(resId, (int)count);
        return String.format(format, count);
    }

    public static CharSequence getRelativeTimeSpanString(Context ctx, ReadablePartial time, boolean withPreposition) {
        return DateUtils.getRelativeTimeSpanString(ctx, (ReadableInstant)time.toDateTime(DateTime.now()), withPreposition);
    }

    public static CharSequence getRelativeTimeSpanString(Context ctx, ReadableInstant time, boolean withPreposition) {
        int prepositionId;
        String result;
        LocalDate timeDate;
        LocalDate now = LocalDate.now();
        if (Days.daysBetween(now, timeDate = new LocalDate(time)).getDays() == 0) {
            int flags = 1;
            result = DateUtils.formatDateRange(ctx, time, time, flags);
            prepositionId = R.string.preposition_for_time;
        } else if (Years.yearsBetween(now, timeDate).getYears() != 0) {
            int flags = 131092;
            result = DateUtils.formatDateRange(ctx, time, time, flags);
            prepositionId = R.string.preposition_for_date;
        } else {
            int flags = 65552;
            result = DateUtils.formatDateRange(ctx, time, time, flags);
            prepositionId = R.string.preposition_for_date;
        }
        if (withPreposition) {
            result = ctx.getString(prepositionId, new Object[]{result});
        }
        return result;
    }

    public static CharSequence getRelativeDateTimeString(Context context, ReadablePartial time, ReadablePeriod transitionResolution, int flags) {
        if (!time.isSupported(DateTimeFieldType.hourOfDay()) || !time.isSupported(DateTimeFieldType.minuteOfHour())) {
            throw new IllegalArgumentException("getRelativeDateTimeString() must be passed a ReadablePartial that supports time, otherwise it makes no sense");
        }
        return DateUtils.getRelativeDateTimeString(context, time.toDateTime(DateTime.now()), transitionResolution, flags);
    }

    public static CharSequence getRelativeDateTimeString(Context context, ReadableInstant time, ReadablePeriod transitionResolution, int flags) {
        String result;
        Duration transitionDuration;
        DateTime timeDt;
        Resources r = context.getResources();
        DateTime now = DateTime.now(time.getZone()).withMillisOfSecond(0);
        boolean past = !now.isBefore(timeDt = new DateTime(time).withMillisOfSecond(0));
        Duration duration = past ? new Duration(timeDt, now) : new Duration(now, timeDt);
        Duration minDuration = Days.ONE.toPeriod().toDurationTo(timeDt);
        if (transitionResolution == null) {
            transitionDuration = minDuration;
        } else {
            Duration maxDuration;
            transitionDuration = past ? transitionResolution.toPeriod().toDurationTo(now) : transitionResolution.toPeriod().toDurationFrom(now);
            if (transitionDuration.isLongerThan(maxDuration = Weeks.ONE.toPeriod().toDurationTo(timeDt))) {
                transitionDuration = maxDuration;
            } else if (transitionDuration.isShorterThan(minDuration)) {
                transitionDuration = minDuration;
            }
        }
        String timeClause = DateUtils.formatDateRange(context, time, time, 1);
        if (!duration.isLongerThan(transitionDuration)) {
            CharSequence relativeClause = DateUtils.getRelativeTimeSpanString(context, time, flags);
            result = r.getString(R.string.relative_time, new Object[]{relativeClause, timeClause});
        } else {
            CharSequence dateClause = DateUtils.getRelativeTimeSpanString(context, time, false);
            result = r.getString(R.string.date_time, new Object[]{dateClause, timeClause});
        }
        return result;
    }

    public static CharSequence formatDuration(Context context, ReadableDuration readableDuration) {
        Resources res = context.getResources();
        Duration duration = readableDuration.toDuration();
        int hours = (int)duration.getStandardHours();
        if (hours != 0) {
            return res.getQuantityString(R.plurals.duration_hours, hours, new Object[]{hours});
        }
        int minutes = (int)duration.getStandardMinutes();
        if (minutes != 0) {
            return res.getQuantityString(R.plurals.duration_minutes, minutes, new Object[]{minutes});
        }
        int seconds = (int)duration.getStandardSeconds();
        return res.getQuantityString(R.plurals.duration_seconds, seconds, new Object[]{seconds});
    }
}

