/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class PeriodFormat {
    private static final String BUNDLE_NAME = "org.joda.time.format.messages";
    private static final ConcurrentMap<Locale, PeriodFormatter> FORMATTERS = new ConcurrentHashMap<Locale, PeriodFormatter>();

    protected PeriodFormat() {
    }

    public static PeriodFormatter getDefault() {
        return PeriodFormat.wordBased(Locale.ENGLISH);
    }

    public static PeriodFormatter wordBased() {
        return PeriodFormat.wordBased(Locale.getDefault());
    }

    public static PeriodFormatter wordBased(Locale locale) {
        PeriodFormatter pf = (PeriodFormatter)FORMATTERS.get(locale);
        if (pf == null) {
            ResourceBundle b = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            pf = PeriodFormat.containsKey(b, "PeriodFormat.regex.separator") ? PeriodFormat.buildRegExFormatter(b) : PeriodFormat.buildNonRegExFormatter(b);
            FORMATTERS.putIfAbsent(locale, pf);
        }
        return pf;
    }

    private static PeriodFormatter buildRegExFormatter(ResourceBundle b) {
        String[] variants = PeriodFormat.retrieveVariants(b);
        String regExSeparator = b.getString("PeriodFormat.regex.separator");
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        builder.appendYears();
        if (PeriodFormat.containsKey(b, "PeriodFormat.years.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.years.regex").split(regExSeparator), b.getString("PeriodFormat.years.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.year"), b.getString("PeriodFormat.years"));
        }
        builder.appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants);
        builder.appendMonths();
        if (PeriodFormat.containsKey(b, "PeriodFormat.months.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.months.regex").split(regExSeparator), b.getString("PeriodFormat.months.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.month"), b.getString("PeriodFormat.months"));
        }
        builder.appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants);
        builder.appendWeeks();
        if (PeriodFormat.containsKey(b, "PeriodFormat.weeks.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.weeks.regex").split(regExSeparator), b.getString("PeriodFormat.weeks.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.week"), b.getString("PeriodFormat.weeks"));
        }
        builder.appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants);
        builder.appendDays();
        if (PeriodFormat.containsKey(b, "PeriodFormat.days.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.days.regex").split(regExSeparator), b.getString("PeriodFormat.days.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.day"), b.getString("PeriodFormat.days"));
        }
        builder.appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants);
        builder.appendHours();
        if (PeriodFormat.containsKey(b, "PeriodFormat.hours.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.hours.regex").split(regExSeparator), b.getString("PeriodFormat.hours.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.hour"), b.getString("PeriodFormat.hours"));
        }
        builder.appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants);
        builder.appendMinutes();
        if (PeriodFormat.containsKey(b, "PeriodFormat.minutes.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.minutes.regex").split(regExSeparator), b.getString("PeriodFormat.minutes.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.minute"), b.getString("PeriodFormat.minutes"));
        }
        builder.appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants);
        builder.appendSeconds();
        if (PeriodFormat.containsKey(b, "PeriodFormat.seconds.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.seconds.regex").split(regExSeparator), b.getString("PeriodFormat.seconds.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.second"), b.getString("PeriodFormat.seconds"));
        }
        builder.appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants);
        builder.appendMillis();
        if (PeriodFormat.containsKey(b, "PeriodFormat.milliseconds.regex")) {
            builder.appendSuffix(b.getString("PeriodFormat.milliseconds.regex").split(regExSeparator), b.getString("PeriodFormat.milliseconds.list").split(regExSeparator));
        } else {
            builder.appendSuffix(b.getString("PeriodFormat.millisecond"), b.getString("PeriodFormat.milliseconds"));
        }
        return builder.toFormatter();
    }

    private static PeriodFormatter buildNonRegExFormatter(ResourceBundle b) {
        String[] variants = PeriodFormat.retrieveVariants(b);
        return new PeriodFormatterBuilder().appendYears().appendSuffix(b.getString("PeriodFormat.year"), b.getString("PeriodFormat.years")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendMonths().appendSuffix(b.getString("PeriodFormat.month"), b.getString("PeriodFormat.months")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendWeeks().appendSuffix(b.getString("PeriodFormat.week"), b.getString("PeriodFormat.weeks")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendDays().appendSuffix(b.getString("PeriodFormat.day"), b.getString("PeriodFormat.days")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendHours().appendSuffix(b.getString("PeriodFormat.hour"), b.getString("PeriodFormat.hours")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendMinutes().appendSuffix(b.getString("PeriodFormat.minute"), b.getString("PeriodFormat.minutes")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendSeconds().appendSuffix(b.getString("PeriodFormat.second"), b.getString("PeriodFormat.seconds")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendMillis().appendSuffix(b.getString("PeriodFormat.millisecond"), b.getString("PeriodFormat.milliseconds")).toFormatter();
    }

    private static String[] retrieveVariants(ResourceBundle b) {
        return new String[]{b.getString("PeriodFormat.space"), b.getString("PeriodFormat.comma"), b.getString("PeriodFormat.commandand"), b.getString("PeriodFormat.commaspaceand")};
    }

    private static boolean containsKey(ResourceBundle bundle, String key) {
        Enumeration<String> en = bundle.getKeys();
        while (en.hasMoreElements()) {
            if (!en.nextElement().equals(key)) continue;
            return true;
        }
        return false;
    }
}

