/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractPartial
implements ReadablePartial,
Comparable<ReadablePartial> {
    protected AbstractPartial() {
    }

    protected abstract DateTimeField getField(int var1, Chronology var2);

    @Override
    public DateTimeFieldType getFieldType(int index) {
        return this.getField(index, this.getChronology()).getType();
    }

    public DateTimeFieldType[] getFieldTypes() {
        DateTimeFieldType[] result = new DateTimeFieldType[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getFieldType(i);
        }
        return result;
    }

    @Override
    public DateTimeField getField(int index) {
        return this.getField(index, this.getChronology());
    }

    public DateTimeField[] getFields() {
        DateTimeField[] result = new DateTimeField[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getField(i);
        }
        return result;
    }

    public int[] getValues() {
        int[] result = new int[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    @Override
    public int get(DateTimeFieldType type) {
        return this.getValue(this.indexOfSupported(type));
    }

    @Override
    public boolean isSupported(DateTimeFieldType type) {
        return this.indexOf(type) != -1;
    }

    public int indexOf(DateTimeFieldType type) {
        int isize = this.size();
        for (int i = 0; i < isize; ++i) {
            if (this.getFieldType(i) != type) continue;
            return i;
        }
        return -1;
    }

    protected int indexOfSupported(DateTimeFieldType type) {
        int index = this.indexOf(type);
        if (index == -1) {
            throw new IllegalArgumentException("Field '" + type + "' is not supported");
        }
        return index;
    }

    protected int indexOf(DurationFieldType type) {
        int isize = this.size();
        for (int i = 0; i < isize; ++i) {
            if (this.getFieldType(i).getDurationType() != type) continue;
            return i;
        }
        return -1;
    }

    protected int indexOfSupported(DurationFieldType type) {
        int index = this.indexOf(type);
        if (index == -1) {
            throw new IllegalArgumentException("Field '" + type + "' is not supported");
        }
        return index;
    }

    @Override
    public DateTime toDateTime(ReadableInstant baseInstant) {
        Chronology chrono = DateTimeUtils.getInstantChronology(baseInstant);
        long instantMillis = DateTimeUtils.getInstantMillis(baseInstant);
        long resolved = chrono.set(this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    @Override
    public boolean equals(Object partial) {
        if (this == partial) {
            return true;
        }
        if (!(partial instanceof ReadablePartial)) {
            return false;
        }
        ReadablePartial other = (ReadablePartial)partial;
        if (this.size() != other.size()) {
            return false;
        }
        int isize = this.size();
        for (int i = 0; i < isize; ++i) {
            if (this.getValue(i) == other.getValue(i) && this.getFieldType(i) == other.getFieldType(i)) continue;
            return false;
        }
        return FieldUtils.equals(this.getChronology(), other.getChronology());
    }

    @Override
    public int hashCode() {
        int total = 157;
        int isize = this.size();
        for (int i = 0; i < isize; ++i) {
            total = 23 * total + this.getValue(i);
            total = 23 * total + this.getFieldType(i).hashCode();
        }
        return total += this.getChronology().hashCode();
    }

    @Override
    public int compareTo(ReadablePartial other) {
        int i;
        if (this == other) {
            return 0;
        }
        if (this.size() != other.size()) {
            throw new ClassCastException("ReadablePartial objects must have matching field types");
        }
        int isize = this.size();
        for (i = 0; i < isize; ++i) {
            if (this.getFieldType(i) == other.getFieldType(i)) continue;
            throw new ClassCastException("ReadablePartial objects must have matching field types");
        }
        isize = this.size();
        for (i = 0; i < isize; ++i) {
            if (this.getValue(i) > other.getValue(i)) {
                return 1;
            }
            if (this.getValue(i) >= other.getValue(i)) continue;
            return -1;
        }
        return 0;
    }

    public boolean isAfter(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(partial) > 0;
    }

    public boolean isBefore(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(partial) < 0;
    }

    public boolean isEqual(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(partial) == 0;
    }

    public String toString(DateTimeFormatter formatter) {
        if (formatter == null) {
            return this.toString();
        }
        return formatter.print(this);
    }
}

