/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractDuration;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.DurationConverter;
import org.joda.time.field.FieldUtils;

public abstract class BaseDuration
extends AbstractDuration
implements ReadableDuration,
Serializable {
    private static final long serialVersionUID = 2581698638990L;
    private volatile long iMillis;

    protected BaseDuration(long duration) {
        this.iMillis = duration;
    }

    protected BaseDuration(long startInstant, long endInstant) {
        this.iMillis = FieldUtils.safeSubtract(endInstant, startInstant);
    }

    protected BaseDuration(ReadableInstant start, ReadableInstant end) {
        if (start == end) {
            this.iMillis = 0L;
        } else {
            long startMillis = DateTimeUtils.getInstantMillis(start);
            long endMillis = DateTimeUtils.getInstantMillis(end);
            this.iMillis = FieldUtils.safeSubtract(endMillis, startMillis);
        }
    }

    protected BaseDuration(Object duration) {
        DurationConverter converter = ConverterManager.getInstance().getDurationConverter(duration);
        this.iMillis = converter.getDurationMillis(duration);
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    protected void setMillis(long duration) {
        this.iMillis = duration;
    }

    public Period toPeriod(PeriodType type) {
        return new Period(this.getMillis(), type);
    }

    public Period toPeriod(Chronology chrono) {
        return new Period(this.getMillis(), chrono);
    }

    public Period toPeriod(PeriodType type, Chronology chrono) {
        return new Period(this.getMillis(), type, chrono);
    }

    public Period toPeriodFrom(ReadableInstant startInstant) {
        return new Period(startInstant, this);
    }

    public Period toPeriodFrom(ReadableInstant startInstant, PeriodType type) {
        return new Period(startInstant, this, type);
    }

    public Period toPeriodTo(ReadableInstant endInstant) {
        return new Period(this, endInstant);
    }

    public Period toPeriodTo(ReadableInstant endInstant, PeriodType type) {
        return new Period(this, endInstant, type);
    }

    public Interval toIntervalFrom(ReadableInstant startInstant) {
        return new Interval(startInstant, this);
    }

    public Interval toIntervalTo(ReadableInstant endInstant) {
        return new Interval(this, endInstant);
    }
}

