/*
 * Decompiled with CFR 0.152.
 */
package net.dapete.locks;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.dapete.locks.LockReference;
import org.jspecify.annotations.Nullable;

abstract class AbstractLocks<K, L> {
    private final Lock instanceLock = new ReentrantLock();
    private final Map<Object, LockReference<K, L>> lockReferenceMap = new HashMap<Object, LockReference<K, L>>();
    private final ReferenceQueue<L> lockReferenceQueue = new ReferenceQueue();
    private final Supplier<L> lockSupplier;

    protected AbstractLocks(Supplier<L> lockSupplier) {
        this.lockSupplier = lockSupplier;
    }

    private L createLock(K key) {
        L newLock = this.lockSupplier.get();
        this.lockReferenceMap.put(key, new LockReference<K, L>(key, newLock, this.lockReferenceQueue));
        return newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final L get(K key) {
        this.processQueue();
        this.instanceLock.lock();
        try {
            Object lock;
            LockReference<K, L> lockReference = this.getLockReference(key);
            if (lockReference != null && (lock = lockReference.get()) != null) {
                Object t = lock;
                return (L)t;
            }
            L l = this.createLock(key);
            return l;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    protected final @Nullable LockReference<K, L> getLockReference(K key) {
        return this.lockReferenceMap.get(key);
    }

    public final int size() {
        this.processQueue();
        this.instanceLock.lock();
        try {
            int n = this.lockReferenceMap.size();
            return n;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    private void processQueue() {
        this.instanceLock.lock();
        try {
            LockReference lockReference;
            while ((lockReference = (LockReference)this.lockReferenceQueue.poll()) != null) {
                this.lockReferenceMap.remove(lockReference.getKey());
            }
        }
        finally {
            this.instanceLock.unlock();
        }
    }
}

