/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCloser {
    private static final Class<DbCloser> CLASS = DbCloser.class;
    private static final Logger logger = LoggerFactory.getLogger(CLASS);

    private DbCloser() {
    }

    public static Statement close(Statement stmt, Logger logExceptionTo, Object name) {
        if (stmt == null) {
            return null;
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            (logExceptionTo == null ? logger : logExceptionTo).warn("SQLException closing " + (name == null ? stmt.toString() : name) + " ignored.", (Throwable)e);
        }
        return null;
    }

    public static Statement close(Statement stmt, Logger logExceptionTo) {
        return DbCloser.close(stmt, logExceptionTo, null);
    }

    public static Statement close(Statement stmt) {
        return DbCloser.close(stmt, null, null);
    }

    public static PreparedStatement close(PreparedStatement stmt, Logger logExceptionTo, Object name) {
        if (stmt == null) {
            return null;
        }
        try {
            stmt.clearParameters();
        }
        catch (SQLException e) {
            (logExceptionTo == null ? logger : logExceptionTo).warn("SQLException clearing parameters for " + (name == null ? stmt.toString() : name) + " ignored.", (Throwable)e);
        }
        DbCloser.close((Statement)stmt, logExceptionTo, name);
        return null;
    }

    public static PreparedStatement close(PreparedStatement stmt, Logger logExceptionTo) {
        return DbCloser.close(stmt, logExceptionTo, null);
    }

    public static PreparedStatement close(PreparedStatement stmt) {
        return DbCloser.close(stmt, null, null);
    }

    public static ResultSet close(ResultSet rs, Logger logExceptionTo, Object name) {
        if (rs == null) {
            return null;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            (logExceptionTo == null ? logger : logExceptionTo).warn("SQLException closing " + (name == null ? rs.toString() : name) + " ignored.", (Throwable)e);
        }
        return null;
    }

    public static ResultSet close(ResultSet rs, Logger logExceptionTo) {
        return DbCloser.close(rs, logExceptionTo, null);
    }

    public static ResultSet close(ResultSet rs) {
        return DbCloser.close(rs, (Logger)null, null);
    }

    public static ResultSet close(ResultSet rs, PreparedStatement stmt, Logger logExceptionTo, Object name) {
        DbCloser.close(rs, logExceptionTo, name);
        DbCloser.close(stmt, logExceptionTo, name);
        return null;
    }

    public static ResultSet close(ResultSet rs, PreparedStatement stmt, Logger logExceptionTo) {
        return DbCloser.close(rs, stmt, logExceptionTo, null);
    }

    public static ResultSet close(ResultSet rs, PreparedStatement stmt) {
        return DbCloser.close(rs, stmt, (Logger)null, null);
    }

    public static Connection close(Connection conn, Logger logExceptionTo, Object name) {
        if (conn == null) {
            return null;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            (logExceptionTo == null ? logger : logExceptionTo).warn("SQLException closing " + (name == null ? conn.toString() : name) + " ignored.", (Throwable)e);
        }
        return null;
    }

    public static Connection close(Connection conn, Logger logExceptionTo) {
        return DbCloser.close(conn, logExceptionTo, null);
    }

    public static Connection close(Connection conn) {
        return DbCloser.close(conn, null, null);
    }

    public static ResultSet close(ResultSet rs, PreparedStatement stmt, Connection conn, Logger logExceptionTo, Object name) {
        DbCloser.close(rs, stmt, logExceptionTo, name);
        DbCloser.close(conn, logExceptionTo, name);
        return null;
    }

    public static ResultSet close(ResultSet rs, PreparedStatement stmt, Connection conn, Logger logExceptionTo) {
        return DbCloser.close(rs, stmt, conn, logExceptionTo, null);
    }

    public static ResultSet close(ResultSet rs, PreparedStatement stmt, Connection conn) {
        return DbCloser.close(rs, stmt, conn, null, null);
    }
}

